/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;

@Internal
public class SingleInputSemanticProperties
implements SemanticProperties {
    private static final long serialVersionUID = 1L;
    private Map<Integer, FieldSet> fieldMapping = new HashMap<Integer, FieldSet>();
    private FieldSet readFields = null;

    @Override
    public FieldSet getForwardingTargetFields(int input, int sourceField) {
        if (input != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.fieldMapping.containsKey(sourceField) ? this.fieldMapping.get(sourceField) : FieldSet.EMPTY_SET;
    }

    @Override
    public int getForwardingSourceField(int input, int targetField) {
        if (input != 0) {
            throw new IndexOutOfBoundsException();
        }
        for (Map.Entry<Integer, FieldSet> e : this.fieldMapping.entrySet()) {
            if (!e.getValue().contains(targetField)) continue;
            return e.getKey();
        }
        return -1;
    }

    @Override
    public FieldSet getReadFields(int input) {
        if (input != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.readFields;
    }

    public void addForwardedField(int sourceField, int targetField) {
        if (this.isTargetFieldPresent(targetField)) {
            throw new SemanticProperties.InvalidSemanticAnnotationException("Target field " + targetField + " was added twice.");
        }
        FieldSet targetFields = this.fieldMapping.get(sourceField);
        if (targetFields != null) {
            this.fieldMapping.put(sourceField, targetFields.addField(targetField));
        } else {
            this.fieldMapping.put(sourceField, new FieldSet((Integer)targetField));
        }
    }

    private boolean isTargetFieldPresent(int targetField) {
        for (FieldSet targetFields : this.fieldMapping.values()) {
            if (!targetFields.contains(targetField)) continue;
            return true;
        }
        return false;
    }

    public void addReadFields(FieldSet readFields) {
        this.readFields = this.readFields == null ? readFields : this.readFields.addFields(readFields);
    }

    public String toString() {
        return "SISP(" + String.valueOf(this.fieldMapping) + ")";
    }

    public static class AllFieldsForwardedProperties
    extends SingleInputSemanticProperties {
        private static final long serialVersionUID = 1L;

        @Override
        public FieldSet getForwardingTargetFields(int input, int sourceField) {
            if (input != 0) {
                throw new IndexOutOfBoundsException();
            }
            return new FieldSet((Integer)sourceField);
        }

        @Override
        public int getForwardingSourceField(int input, int targetField) {
            if (input != 0) {
                throw new IndexOutOfBoundsException();
            }
            return targetField;
        }

        @Override
        public void addForwardedField(int sourceField, int targetField) {
            throw new UnsupportedOperationException("Cannot modify forwarded fields");
        }
    }
}

