/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.serde;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.api.results.ResultSetImpl;
import org.apache.flink.table.gateway.rest.serde.ColumnInfo;
import org.apache.flink.table.gateway.rest.serde.ResultInfoDeserializer;
import org.apache.flink.table.gateway.rest.serde.ResultInfoSerializer;
import org.apache.flink.table.gateway.rest.util.RowDataLocalTimeZoneConverter;
import org.apache.flink.table.gateway.rest.util.RowFormat;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.apache.flink.util.Preconditions;

@Internal
@JsonSerialize(using=ResultInfoSerializer.class)
@JsonDeserialize(using=ResultInfoDeserializer.class)
public class ResultInfo {
    private final List<ColumnInfo> columnInfos;
    private final List<RowData> data;
    private final RowFormat rowFormat;

    ResultInfo(List<ColumnInfo> columnInfos, List<RowData> data, RowFormat rowFormat) {
        this.columnInfos = columnInfos;
        this.data = data;
        this.rowFormat = rowFormat;
    }

    public static ResultInfo createResultInfo(ResultSet resultSet, RowFormat rowFormat, @Nullable RowDataLocalTimeZoneConverter timeZoneConverter) {
        Preconditions.checkArgument(resultSet.getResultType() != ResultSet.ResultType.NOT_READY);
        List<RowData> data = resultSet.getData();
        switch (rowFormat) {
            case JSON: {
                if (timeZoneConverter == null || !timeZoneConverter.hasTimeZoneData()) break;
                data = data.stream().map(timeZoneConverter::convertTimeZoneRowData).collect(Collectors.toList());
                break;
            }
            case PLAIN_TEXT: {
                RowDataToStringConverter converter = ((ResultSetImpl)resultSet).getConverter();
                data = data.stream().map(rowData -> ResultInfo.convertToPlainText(rowData, converter)).collect(Collectors.toList());
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported row format: %s.", new Object[]{rowFormat}));
            }
        }
        return new ResultInfo(resultSet.getResultSchema().getColumns().stream().map(ColumnInfo::toColumnInfo).collect(Collectors.toList()), data, rowFormat);
    }

    public List<ColumnInfo> getColumnInfos() {
        return Collections.unmodifiableList(this.columnInfos);
    }

    public List<RowData> getData() {
        return this.data;
    }

    public RowFormat getRowFormat() {
        return this.rowFormat;
    }

    public List<RowData.FieldGetter> getFieldGetters() {
        if (this.rowFormat == RowFormat.JSON) {
            List columnTypes = this.columnInfos.stream().map(ColumnInfo::getLogicalType).collect(Collectors.toList());
            return IntStream.range(0, columnTypes.size()).mapToObj(i -> RowData.createFieldGetter((LogicalType)columnTypes.get(i), i)).collect(Collectors.toList());
        }
        return IntStream.range(0, this.columnInfos.size()).mapToObj(i -> RowData.createFieldGetter(VarCharType.STRING_TYPE, i)).collect(Collectors.toList());
    }

    public ResolvedSchema getResultSchema() {
        return ResolvedSchema.of(this.columnInfos.stream().map(ColumnInfo::toColumn).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResultInfo)) {
            return false;
        }
        ResultInfo that = (ResultInfo)o;
        return Objects.equals(this.columnInfos, that.columnInfos) && Objects.equals(this.data, that.data) && this.rowFormat == that.rowFormat;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnInfos, this.data, this.rowFormat});
    }

    public String toString() {
        return "ResultInfo{columnInfos=" + this.columnInfos + ", data=" + this.data + ", rowFormat=" + this.rowFormat + "}";
    }

    private static RowData convertToPlainText(RowData rowData, RowDataToStringConverter converter) {
        String[] plainTexts = converter.convert(rowData);
        IntStream.range(0, rowData.getArity()).filter(rowData::isNullAt).forEach(i -> {
            plainTexts[i] = null;
        });
        return GenericRowData.ofKind(rowData.getRowKind(), Arrays.stream(plainTexts).map(StringData::fromString).toArray());
    }
}

