/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.DefaultCatalogMaterializedTable;
import org.apache.flink.table.catalog.IntervalFreshness;
import org.apache.flink.table.utils.IntervalFreshnessUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public interface CatalogMaterializedTable
extends CatalogBaseTable {
    @PublicEvolving
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    default public CatalogBaseTable.TableKind getTableKind() {
        return CatalogBaseTable.TableKind.MATERIALIZED_TABLE;
    }

    public boolean isPartitioned();

    public List<String> getPartitionKeys();

    public CatalogMaterializedTable copy(Map<String, String> var1);

    public CatalogMaterializedTable copy(RefreshStatus var1, String var2, byte[] var3);

    public Optional<Long> getSnapshot();

    public String getDefinitionQuery();

    public IntervalFreshness getDefinitionFreshness();

    default public Duration getFreshness() {
        return IntervalFreshnessUtils.convertFreshnessToDuration(this.getDefinitionFreshness());
    }

    public LogicalRefreshMode getLogicalRefreshMode();

    public RefreshMode getRefreshMode();

    public RefreshStatus getRefreshStatus();

    public Optional<String> getRefreshHandlerDescription();

    @Nullable
    public byte[] getSerializedRefreshHandler();

    @PublicEvolving
    public static class Builder {
        private Schema schema;
        private String comment;
        private List<String> partitionKeys = Collections.emptyList();
        private Map<String, String> options = Collections.emptyMap();
        @Nullable
        private Long snapshot;
        private String definitionQuery;
        private IntervalFreshness freshness;
        private LogicalRefreshMode logicalRefreshMode;
        private RefreshMode refreshMode;
        private RefreshStatus refreshStatus;
        @Nullable
        private String refreshHandlerDescription;
        @Nullable
        private byte[] serializedRefreshHandler;

        private Builder() {
        }

        public Builder schema(Schema schema) {
            this.schema = Preconditions.checkNotNull(schema, "Schema must not be null.");
            return this;
        }

        public Builder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        public Builder partitionKeys(List<String> partitionKeys) {
            this.partitionKeys = Preconditions.checkNotNull(partitionKeys, "Partition keys must not be null.");
            return this;
        }

        public Builder options(Map<String, String> options) {
            this.options = Preconditions.checkNotNull(options, "Options must not be null.");
            return this;
        }

        public Builder snapshot(@Nullable Long snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public Builder definitionQuery(String definitionQuery) {
            this.definitionQuery = Preconditions.checkNotNull(definitionQuery, "Definition query must not be null.");
            return this;
        }

        public Builder freshness(IntervalFreshness freshness) {
            this.freshness = Preconditions.checkNotNull(freshness, "Freshness must not be null.");
            return this;
        }

        public Builder logicalRefreshMode(LogicalRefreshMode logicalRefreshMode) {
            this.logicalRefreshMode = Preconditions.checkNotNull(logicalRefreshMode, "Logical refresh mode must not be null.");
            return this;
        }

        public Builder refreshMode(RefreshMode refreshMode) {
            this.refreshMode = Preconditions.checkNotNull(refreshMode, "Refresh mode must not be null.");
            return this;
        }

        public Builder refreshStatus(RefreshStatus refreshStatus) {
            this.refreshStatus = Preconditions.checkNotNull(refreshStatus, "Refresh status must not be null.");
            return this;
        }

        public Builder refreshHandlerDescription(@Nullable String refreshHandlerDescription) {
            this.refreshHandlerDescription = refreshHandlerDescription;
            return this;
        }

        public Builder serializedRefreshHandler(@Nullable byte[] serializedRefreshHandler) {
            this.serializedRefreshHandler = serializedRefreshHandler;
            return this;
        }

        public CatalogMaterializedTable build() {
            return new DefaultCatalogMaterializedTable(this.schema, this.comment, this.partitionKeys, this.options, this.snapshot, this.definitionQuery, this.freshness, this.logicalRefreshMode, this.refreshMode, this.refreshStatus, this.refreshHandlerDescription, this.serializedRefreshHandler);
        }
    }

    @PublicEvolving
    public static enum RefreshStatus {
        INITIALIZING,
        ACTIVATED,
        SUSPENDED;

    }

    @PublicEvolving
    public static enum RefreshMode {
        CONTINUOUS,
        FULL;

    }

    @PublicEvolving
    public static enum LogicalRefreshMode {
        CONTINUOUS,
        FULL,
        AUTOMATIC;

    }
}

