/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.PublicEvolving;

@Experimental
public abstract class PlanReference {
    private PlanReference() {
    }

    public static PlanReference fromFile(String path) {
        Objects.requireNonNull(path, "Path cannot be null");
        return PlanReference.fromFile(Paths.get(path, new String[0]).toFile());
    }

    public static PlanReference fromFile(Path path) {
        Objects.requireNonNull(path, "Path cannot be null");
        return PlanReference.fromFile(path.toFile());
    }

    public static PlanReference fromFile(File file) {
        Objects.requireNonNull(file, "File cannot be null");
        return new FilePlanReference(file);
    }

    public static PlanReference fromJsonString(String jsonString) {
        Objects.requireNonNull(jsonString, "Json string cannot be null");
        return new JsonContentPlanReference(jsonString);
    }

    public static PlanReference fromSmileBytes(byte[] smileBytes) {
        Objects.requireNonNull(smileBytes, "Smile bytes cannot be null");
        return new BytesContentPlanReference(smileBytes);
    }

    public static PlanReference fromResource(String resourcePath) {
        Objects.requireNonNull(resourcePath, "Resource path cannot be null");
        return PlanReference.fromResource(Thread.currentThread().getContextClassLoader(), resourcePath);
    }

    public static PlanReference fromResource(ClassLoader classLoader, String resourcePath) {
        Objects.requireNonNull(classLoader, "ClassLoader cannot be null");
        Objects.requireNonNull(resourcePath, "Resource path cannot be null");
        return new ResourcePlanReference(classLoader, resourcePath);
    }

    @Experimental
    public static class ResourcePlanReference
    extends PlanReference {
        private final ClassLoader classLoader;
        private final String resourcePath;

        private ResourcePlanReference(ClassLoader classLoader, String resourcePath) {
            this.classLoader = classLoader;
            this.resourcePath = resourcePath.startsWith("/") ? resourcePath.substring(1) : resourcePath;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourcePlanReference that = (ResourcePlanReference)o;
            return Objects.equals(this.classLoader, that.classLoader) && Objects.equals(this.resourcePath, that.resourcePath);
        }

        public int hashCode() {
            return Objects.hash(this.classLoader, this.resourcePath);
        }

        public String toString() {
            return "Plan from resource '" + this.resourcePath + "' in classloader '" + this.classLoader + "'";
        }
    }

    @PublicEvolving
    public static class BytesContentPlanReference
    extends PlanReference {
        private final byte[] content;

        private BytesContentPlanReference(byte[] content) {
            this.content = content;
        }

        public byte[] getContent() {
            return this.content;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BytesContentPlanReference that = (BytesContentPlanReference)o;
            return Arrays.equals(this.content, that.content);
        }

        public int hashCode() {
            return Arrays.hashCode(this.content);
        }

        public String toString() {
            return "Plan:\n" + Arrays.toString(this.content);
        }
    }

    @PublicEvolving
    public static class JsonContentPlanReference
    extends PlanReference {
        private final String content;

        private JsonContentPlanReference(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonContentPlanReference that = (JsonContentPlanReference)o;
            return Objects.equals(this.content, that.content);
        }

        public int hashCode() {
            return Objects.hash(this.content);
        }

        public String toString() {
            return "Plan:\n" + this.content;
        }
    }

    @Experimental
    public static class FilePlanReference
    extends PlanReference {
        private final File file;

        private FilePlanReference(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilePlanReference that = (FilePlanReference)o;
            return Objects.equals(this.file, that.file);
        }

        public int hashCode() {
            return Objects.hash(this.file);
        }

        public String toString() {
            return "Plan from file '" + this.file + "'";
        }
    }
}

