/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.Iterator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.QueryableStateOptions;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.Preconditions;

public class QueryableStateConfiguration {
    private final Iterator<Integer> proxyPortRange;
    private final Iterator<Integer> qserverPortRange;
    private final int numProxyThreads;
    private final int numPQueryThreads;
    private final int numServerThreads;
    private final int numSQueryThreads;

    public QueryableStateConfiguration(Iterator<Integer> proxyPortRange, Iterator<Integer> qserverPortRange, int numProxyThreads, int numPQueryThreads, int numServerThreads, int numSQueryThreads) {
        Preconditions.checkArgument(proxyPortRange != null && proxyPortRange.hasNext());
        Preconditions.checkArgument(qserverPortRange != null && qserverPortRange.hasNext());
        Preconditions.checkArgument(numProxyThreads >= 0, "queryable state number of proxy threads must be zero or larger");
        Preconditions.checkArgument(numPQueryThreads >= 0, "queryable state number of proxy query threads must be zero or larger");
        Preconditions.checkArgument(numServerThreads >= 0, "queryable state number of server threads must be zero or larger");
        Preconditions.checkArgument(numSQueryThreads >= 0, "queryable state number of query threads must be zero or larger");
        this.proxyPortRange = proxyPortRange;
        this.qserverPortRange = qserverPortRange;
        this.numProxyThreads = numProxyThreads;
        this.numPQueryThreads = numPQueryThreads;
        this.numServerThreads = numServerThreads;
        this.numSQueryThreads = numSQueryThreads;
    }

    public Iterator<Integer> getProxyPortRange() {
        return this.proxyPortRange;
    }

    public Iterator<Integer> getStateServerPortRange() {
        return this.qserverPortRange;
    }

    public int numProxyServerThreads() {
        return this.numProxyThreads;
    }

    public int numProxyQueryThreads() {
        return this.numPQueryThreads;
    }

    public int numStateServerThreads() {
        return this.numServerThreads;
    }

    public int numStateQueryThreads() {
        return this.numSQueryThreads;
    }

    public String toString() {
        return "QueryableStateConfiguration{numProxyServerThreads=" + this.numProxyThreads + ", numProxyQueryThreads=" + this.numPQueryThreads + ", numStateServerThreads=" + this.numServerThreads + ", numStateQueryThreads=" + this.numSQueryThreads + "}";
    }

    public static QueryableStateConfiguration disabled() {
        Iterator<Integer> proxyPorts = NetUtils.getPortRangeFromString(QueryableStateOptions.PROXY_PORT_RANGE.defaultValue());
        Iterator<Integer> serverPorts = NetUtils.getPortRangeFromString(QueryableStateOptions.SERVER_PORT_RANGE.defaultValue());
        return new QueryableStateConfiguration(proxyPorts, serverPorts, 0, 0, 0, 0);
    }

    public static QueryableStateConfiguration fromConfiguration(Configuration config) {
        if (!config.get(QueryableStateOptions.ENABLE_QUERYABLE_STATE_PROXY_SERVER).booleanValue()) {
            return null;
        }
        Iterator<Integer> proxyPorts = NetUtils.getPortRangeFromString(config.get(QueryableStateOptions.PROXY_PORT_RANGE));
        Iterator<Integer> serverPorts = NetUtils.getPortRangeFromString(config.get(QueryableStateOptions.SERVER_PORT_RANGE));
        int numProxyServerNetworkThreads = config.get(QueryableStateOptions.PROXY_NETWORK_THREADS);
        int numProxyServerQueryThreads = config.get(QueryableStateOptions.PROXY_ASYNC_QUERY_THREADS);
        int numStateServerNetworkThreads = config.get(QueryableStateOptions.SERVER_NETWORK_THREADS);
        int numStateServerQueryThreads = config.get(QueryableStateOptions.SERVER_ASYNC_QUERY_THREADS);
        return new QueryableStateConfiguration(proxyPorts, serverPorts, numProxyServerNetworkThreads, numProxyServerQueryThreads, numStateServerNetworkThreads, numStateServerQueryThreads);
    }
}

