/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2.ttl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.common.state.v2.StateIterator;
import org.apache.flink.runtime.state.ttl.TtlStateContext;
import org.apache.flink.runtime.state.ttl.TtlUtils;
import org.apache.flink.runtime.state.ttl.TtlValue;
import org.apache.flink.runtime.state.v2.internal.InternalListState;
import org.apache.flink.runtime.state.v2.ttl.AbstractTtlState;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.ThrowingConsumer;

class TtlListState<K, N, T>
extends AbstractTtlState<K, N, T, TtlValue<T>, InternalListState<K, N, TtlValue<T>>>
implements InternalListState<K, N, T> {
    protected TtlListState(TtlStateContext<InternalListState<K, N, TtlValue<T>>, T> ttlStateContext) {
        super(ttlStateContext);
    }

    @Override
    public StateFuture<Void> asyncUpdate(List<T> values) {
        Preconditions.checkNotNull(values, "List of values to add cannot be null.");
        return ((InternalListState)this.original).asyncUpdate(this.withTs(values));
    }

    @Override
    public StateFuture<Void> asyncAddAll(List<T> values) {
        Preconditions.checkNotNull(values, "List of values to add cannot be null.");
        return ((InternalListState)this.original).asyncAddAll(this.withTs(values));
    }

    @Override
    public StateFuture<StateIterator<T>> asyncGet() {
        return ((InternalListState)this.original).asyncGet().thenApply(stateIter -> new AsyncIteratorWrapper(stateIter));
    }

    @Override
    public StateFuture<Void> asyncAdd(T value) {
        return ((InternalListState)this.original).asyncAdd(value == null ? null : this.wrapWithTs(value));
    }

    @Override
    public Iterable<T> get() {
        Iterable<Object> ttlValue = (Iterable)((InternalListState)this.original).get();
        Iterable<Object> finalResult = ttlValue = ttlValue == null ? Collections.emptyList() : ttlValue;
        return () -> new IteratorWithCleanup(finalResult.iterator());
    }

    @Override
    public void add(T value) {
        ((InternalListState)this.original).add(value == null ? null : this.wrapWithTs(value));
    }

    @Override
    public void update(List<T> values) {
        Preconditions.checkNotNull(values, "List of values to add cannot be null.");
        ((InternalListState)this.original).update(this.withTs(values));
    }

    @Override
    public void addAll(List<T> values) {
        Preconditions.checkNotNull(values, "List of values to add cannot be null.");
        ((InternalListState)this.original).addAll(this.withTs(values));
    }

    private <E> List<E> collect(Iterable<E> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<E> list = new ArrayList<E>();
        for (E element : iterable) {
            list.add(element);
        }
        return list;
    }

    private List<TtlValue<T>> withTs(List<T> values) {
        long currentTimestamp = this.timeProvider.currentTimestamp();
        ArrayList<TtlValue<T>> withTs = new ArrayList<TtlValue<T>>(values.size());
        for (T value : values) {
            Preconditions.checkNotNull(value, "You cannot have null element in a ListState.");
            withTs.add(TtlUtils.wrapWithTs(value, currentTimestamp));
        }
        return withTs;
    }

    @Override
    public StateFuture<Void> asyncMergeNamespaces(N target, Collection<N> sources) {
        return ((InternalListState)this.original).asyncMergeNamespaces(target, sources);
    }

    @Override
    public void mergeNamespaces(N target, Collection<N> sources) {
        ((InternalListState)this.original).mergeNamespaces(target, sources);
    }

    private class AsyncIteratorWrapper
    implements StateIterator<T> {
        private final StateIterator<TtlValue<T>> originalIterator;

        public AsyncIteratorWrapper(StateIterator<TtlValue<T>> originalIterator) {
            this.originalIterator = originalIterator;
        }

        @Override
        public <U> StateFuture<Collection<U>> onNext(FunctionWithException<T, StateFuture<? extends U>, Exception> iterating) {
            FunctionWithException ttlIterating = item -> {
                Object element = TtlListState.this.getElementWithTtlCheck(item);
                if (element != null) {
                    return (StateFuture)iterating.apply(element);
                }
                return null;
            };
            return this.originalIterator.onNext(ttlIterating);
        }

        @Override
        public StateFuture<Void> onNext(ThrowingConsumer<T, Exception> iterating) {
            ThrowingConsumer ttlIterating = item -> {
                Object element = TtlListState.this.getElementWithTtlCheck(item);
                if (element != null) {
                    iterating.accept(element);
                }
            };
            return this.originalIterator.onNext(ttlIterating);
        }

        @Override
        public boolean isEmpty() {
            return this.originalIterator.isEmpty();
        }
    }

    private class IteratorWithCleanup
    implements Iterator<T> {
        private final Iterator<TtlValue<T>> originalIterator;
        private boolean anyUnexpired = false;
        private boolean uncleared = true;
        private T nextUnexpired = null;

        private IteratorWithCleanup(Iterator<TtlValue<T>> ttlIterator) {
            this.originalIterator = ttlIterator;
        }

        @Override
        public boolean hasNext() {
            this.findNextUnexpired();
            this.cleanupIfEmpty();
            return this.nextUnexpired != null;
        }

        private void cleanupIfEmpty() {
            boolean endOfIter;
            boolean bl = endOfIter = !this.originalIterator.hasNext() && this.nextUnexpired == null;
            if (this.uncleared && !this.anyUnexpired && endOfIter) {
                ((InternalListState)TtlListState.this.original).clear();
                this.uncleared = false;
            }
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                Object result = this.nextUnexpired;
                this.nextUnexpired = null;
                return result;
            }
            throw new NoSuchElementException();
        }

        private void findNextUnexpired() {
            TtlValue ttlValue;
            while (this.nextUnexpired == null && this.originalIterator.hasNext() && (ttlValue = this.originalIterator.next()) != null) {
                boolean unexpired;
                boolean bl = unexpired = !TtlListState.this.expired(ttlValue);
                if (unexpired) {
                    this.anyUnexpired = true;
                }
                if (!unexpired && !TtlListState.this.returnExpired) continue;
                this.nextUnexpired = ttlValue.getUserValue();
            }
        }
    }
}

