/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.queryablestate.client.state.serialization.KvStateSerializer;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.util.Preconditions;

public abstract class AbstractHeapState<K, N, SV>
implements InternalKvState<K, N, SV> {
    protected final StateTable<K, N, SV> stateTable;
    protected N currentNamespace;
    protected final TypeSerializer<K> keySerializer;
    protected TypeSerializer<SV> valueSerializer;
    protected TypeSerializer<N> namespaceSerializer;
    private SV defaultValue;

    AbstractHeapState(StateTable<K, N, SV> stateTable, TypeSerializer<K> keySerializer, TypeSerializer<SV> valueSerializer, TypeSerializer<N> namespaceSerializer, SV defaultValue) {
        this.stateTable = Preconditions.checkNotNull(stateTable, "State table must not be null.");
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.namespaceSerializer = namespaceSerializer;
        this.defaultValue = defaultValue;
        this.currentNamespace = null;
    }

    @Override
    public final void clear() {
        this.stateTable.remove(this.currentNamespace);
    }

    @Override
    public final void setCurrentNamespace(N namespace) {
        this.currentNamespace = Preconditions.checkNotNull(namespace, "Namespace must not be null.");
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<SV> safeValueSerializer) throws Exception {
        Preconditions.checkNotNull(serializedKeyAndNamespace);
        Preconditions.checkNotNull(safeKeySerializer);
        Preconditions.checkNotNull(safeNamespaceSerializer);
        Preconditions.checkNotNull(safeValueSerializer);
        Tuple2 keyAndNamespace = KvStateSerializer.deserializeKeyAndNamespace((byte[])serializedKeyAndNamespace, safeKeySerializer, safeNamespaceSerializer);
        SV result = this.stateTable.get(keyAndNamespace.f0, keyAndNamespace.f1);
        if (result == null) {
            return null;
        }
        return KvStateSerializer.serializeValue(result, safeValueSerializer);
    }

    @VisibleForTesting
    public StateTable<K, N, SV> getStateTable() {
        return this.stateTable;
    }

    protected SV getDefaultValue() {
        if (this.defaultValue != null) {
            return this.valueSerializer.copy(this.defaultValue);
        }
        return null;
    }

    protected AbstractHeapState<K, N, SV> setNamespaceSerializer(TypeSerializer<N> namespaceSerializer) {
        this.namespaceSerializer = namespaceSerializer;
        return this;
    }

    protected AbstractHeapState<K, N, SV> setValueSerializer(TypeSerializer<SV> valueSerializer) {
        this.valueSerializer = valueSerializer;
        return this;
    }

    protected AbstractHeapState<K, N, SV> setDefaultValue(SV defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public InternalKvState.StateIncrementalVisitor<K, N, SV> getStateIncrementalVisitor(int recommendedMaxNumberOfReturnedRecords) {
        return this.stateTable.getStateIncrementalVisitor(recommendedMaxNumberOfReturnedRecords);
    }
}

