/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.flink.runtime.rest.messages.ConversionException;
import org.apache.flink.runtime.rest.messages.MessageParameter;
import org.apache.flink.runtime.rest.messages.MessageQueryParameter;

public class FailureLabelFilterParameter
extends MessageQueryParameter<FailureLabel> {
    public static final String KEY = "failureLabelFilter";

    public FailureLabelFilterParameter() {
        super(KEY, MessageParameter.MessageParameterRequisiteness.OPTIONAL);
    }

    @Override
    public List<FailureLabel> convertFromString(String values) throws ConversionException {
        String[] splitValues = values.split(",");
        HashSet<FailureLabel> result = new HashSet<FailureLabel>();
        for (String value : splitValues) {
            result.add(this.convertStringToValue(value));
        }
        return new ArrayList<FailureLabel>(result);
    }

    @Override
    public FailureLabel convertStringToValue(String value) throws ConversionException {
        String[] tokens = value.split(":");
        if (tokens.length != 2) {
            throw new ConversionException(String.format("%s may be a `key:value` entry only (%s)", KEY, value));
        }
        return new FailureLabel(tokens[0], tokens[1]);
    }

    @Override
    public String convertValueToString(FailureLabel value) {
        return value.toString();
    }

    @Override
    public String getDescription() {
        return "Collection of string values working as a filter in the form of `key:value` pairs allowing only exceptions with ALL of the specified failure labels to be returned.";
    }

    public static class FailureLabel {
        private final String key;
        private final String value;

        public FailureLabel(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

