/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Set;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequestBulk;

class PhysicalSlotRequestBulkWithTimestamp
implements PhysicalSlotRequestBulk {
    private final PhysicalSlotRequestBulk physicalSlotRequestBulk;
    private long unfulfillableTimestamp = Long.MAX_VALUE;

    PhysicalSlotRequestBulkWithTimestamp(PhysicalSlotRequestBulk physicalSlotRequestBulk) {
        this.physicalSlotRequestBulk = physicalSlotRequestBulk;
    }

    void markFulfillable() {
        this.unfulfillableTimestamp = Long.MAX_VALUE;
    }

    void markUnfulfillable(long currentTimestamp) {
        if (this.isFulfillable()) {
            this.unfulfillableTimestamp = currentTimestamp;
        }
    }

    long getUnfulfillableSince() {
        return this.unfulfillableTimestamp;
    }

    private boolean isFulfillable() {
        return this.unfulfillableTimestamp == Long.MAX_VALUE;
    }

    @Override
    public Collection<ResourceProfile> getPendingRequests() {
        return this.physicalSlotRequestBulk.getPendingRequests();
    }

    @Override
    public Set<AllocationID> getAllocationIdsOfFulfilledRequests() {
        return this.physicalSlotRequestBulk.getAllocationIdsOfFulfilledRequests();
    }

    @Override
    public void cancel(Throwable cause) {
        this.physicalSlotRequestBulk.cancel(cause);
    }
}

