/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blocklist.BlockedTaskManagerChecker;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultDeclarativeSlotPool;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.ResourceCounter;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

public class BlocklistDeclarativeSlotPool
extends DefaultDeclarativeSlotPool {
    private final BlockedTaskManagerChecker blockedTaskManagerChecker;

    BlocklistDeclarativeSlotPool(JobID jobId, AllocatedSlotPool slotPool, Consumer<? super Collection<ResourceRequirement>> notifyNewResourceRequirements, BlockedTaskManagerChecker blockedTaskManagerChecker, Duration idleSlotTimeout, Duration rpcTimeout, Duration slotRequestMaxInterval, ComponentMainThreadExecutor componentMainThreadExecutor) {
        super(jobId, slotPool, notifyNewResourceRequirements, idleSlotTimeout, rpcTimeout, slotRequestMaxInterval, componentMainThreadExecutor);
        this.blockedTaskManagerChecker = Preconditions.checkNotNull(blockedTaskManagerChecker);
    }

    @Override
    public Collection<SlotOffer> offerSlots(Collection<? extends SlotOffer> offers, TaskManagerLocation taskManagerLocation, TaskManagerGateway taskManagerGateway, long currentTime) {
        if (!this.isBlockedTaskManager(taskManagerLocation.getResourceID())) {
            return super.offerSlots(offers, taskManagerLocation, taskManagerGateway, currentTime);
        }
        return this.internalOfferSlotsFromBlockedTaskManager(offers, taskManagerLocation);
    }

    @Override
    public Collection<SlotOffer> registerSlots(Collection<? extends SlotOffer> slots, TaskManagerLocation taskManagerLocation, TaskManagerGateway taskManagerGateway, long currentTime) {
        if (!this.isBlockedTaskManager(taskManagerLocation.getResourceID())) {
            return super.registerSlots(slots, taskManagerLocation, taskManagerGateway, currentTime);
        }
        return this.internalOfferSlotsFromBlockedTaskManager(slots, taskManagerLocation);
    }

    private Collection<SlotOffer> internalOfferSlotsFromBlockedTaskManager(Collection<? extends SlotOffer> offers, TaskManagerLocation taskManagerLocation) {
        ArrayList<SlotOffer> acceptedSlotOffers = new ArrayList<SlotOffer>();
        ArrayList<SlotOffer> rejectedSlotOffers = new ArrayList<SlotOffer>();
        for (SlotOffer slotOffer : offers) {
            if (this.slotPool.containsSlot(slotOffer.getAllocationId())) {
                acceptedSlotOffers.add(slotOffer);
                continue;
            }
            rejectedSlotOffers.add(slotOffer);
        }
        this.log.debug("Received {} slots from a blocked TaskManager {}, {} was accepted before: {}, {} was rejected: {}.", new Object[]{offers.size(), taskManagerLocation, acceptedSlotOffers.size(), acceptedSlotOffers, rejectedSlotOffers.size(), rejectedSlotOffers});
        return acceptedSlotOffers;
    }

    @Override
    public ResourceCounter freeReservedSlot(AllocationID allocationId, @Nullable Throwable cause, long currentTime) {
        Optional<SlotInfo> slotInfo = this.slotPool.getSlotInformation(allocationId);
        if (!slotInfo.isPresent()) {
            return ResourceCounter.empty();
        }
        ResourceID taskManagerId = slotInfo.get().getTaskManagerLocation().getResourceID();
        if (!this.isBlockedTaskManager(taskManagerId)) {
            return super.freeReservedSlot(allocationId, cause, currentTime);
        }
        this.log.debug("Free reserved slot {}.", (Object)allocationId);
        return this.releaseSlot(allocationId, new FlinkRuntimeException(String.format("Free reserved slot %s on blocked task manager %s.", allocationId, taskManagerId.getStringWithMetadata())));
    }

    private boolean isBlockedTaskManager(ResourceID resourceID) {
        return this.blockedTaskManagerChecker.isBlockedTaskManager(resourceID);
    }
}

