/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.AvailabilityProvider;
import org.apache.flink.runtime.io.PullingAsyncDataInput;
import org.apache.flink.runtime.io.network.partition.ChannelStateHolder;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.util.Preconditions;

public abstract class InputGate
implements PullingAsyncDataInput<BufferOrEvent>,
AutoCloseable,
ChannelStateHolder {
    protected final AvailabilityProvider.AvailabilityHelper availabilityHelper = new AvailabilityProvider.AvailabilityHelper();
    protected final AvailabilityProvider.AvailabilityHelper priorityAvailabilityHelper = new AvailabilityProvider.AvailabilityHelper();

    @Override
    public void setChannelStateWriter(ChannelStateWriter channelStateWriter) {
        int numChannels = this.getNumberOfInputChannels();
        for (int index = 0; index < numChannels; ++index) {
            InputChannel channel = this.getChannel(index);
            if (!(channel instanceof ChannelStateHolder)) continue;
            ((ChannelStateHolder)((Object)channel)).setChannelStateWriter(channelStateWriter);
        }
    }

    public abstract int getNumberOfInputChannels();

    @Override
    public abstract boolean isFinished();

    public abstract Optional<BufferOrEvent> getNext() throws IOException, InterruptedException;

    @Override
    public abstract Optional<BufferOrEvent> pollNext() throws IOException, InterruptedException;

    public abstract void sendTaskEvent(TaskEvent var1) throws IOException;

    @Override
    public CompletableFuture<?> getAvailableFuture() {
        return this.availabilityHelper.getAvailableFuture();
    }

    public abstract void resumeGateConsumption() throws IOException;

    public abstract void resumeConsumption(InputChannelInfo var1) throws IOException;

    public abstract void acknowledgeAllRecordsProcessed(InputChannelInfo var1) throws IOException;

    public abstract InputChannel getChannel(int var1);

    public List<InputChannelInfo> getChannelInfos() {
        return IntStream.range(0, this.getNumberOfInputChannels()).mapToObj(index -> this.getChannel(index).getChannelInfo()).collect(Collectors.toList());
    }

    public CompletableFuture<?> getPriorityEventAvailableFuture() {
        return this.priorityAvailabilityHelper.getAvailableFuture();
    }

    public abstract void setup() throws IOException;

    public abstract void requestPartitions() throws IOException;

    public abstract CompletableFuture<Void> getStateConsumedFuture();

    public abstract void finishReadRecoveredState() throws IOException;

    protected static class InputWithData<INPUT, DATA> {
        protected final INPUT input;
        protected final DATA data;
        protected final boolean moreAvailable;
        protected final boolean morePriorityEvents;

        InputWithData(INPUT input, DATA data, boolean moreAvailable, boolean morePriorityEvents) {
            this.input = Preconditions.checkNotNull(input);
            this.data = Preconditions.checkNotNull(data);
            this.moreAvailable = moreAvailable;
            this.morePriorityEvents = morePriorityEvents;
        }

        public String toString() {
            return "InputWithData{input=" + this.input + ", data=" + this.data + ", moreAvailable=" + this.moreAvailable + ", morePriorityEvents=" + this.morePriorityEvents + "}";
        }
    }
}

