/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program.artifact;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactUtils.class);

    public static synchronized void createMissingParents(File baseDir) {
        Preconditions.checkNotNull(baseDir, "Base dir has to be provided.");
        if (!baseDir.exists()) {
            try {
                FileUtils.forceMkdirParent((File)baseDir);
                LOG.info("Created parents for base dir: {}", (Object)baseDir);
            }
            catch (Exception e) {
                throw new FlinkRuntimeException(String.format("Failed to create parent(s) for given base dir: %s", baseDir), e);
            }
        }
    }

    private ArtifactUtils() {
        throw new UnsupportedOperationException("This class should never be instantiated.");
    }
}

