/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public class SubQueryInputTypeStrategy
implements InputTypeStrategy {
    @Override
    public ArgumentCount getArgumentCount() {
        return ConstantArgumentCount.from(2);
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        LogicalType rightType;
        DataType leftType = callContext.getArgumentDataTypes().get(0);
        if (callContext.getArgumentDataTypes().size() > 2) {
            Optional<LogicalType> commonType = LogicalTypeMerging.findCommonType(callContext.getArgumentDataTypes().stream().map(DataType::getLogicalType).collect(Collectors.toList()));
            if (!commonType.isPresent()) {
                return callContext.fail(throwOnFailure, "Could not find a common type of the sublist.", new Object[0]);
            }
            rightType = commonType.get();
        } else {
            rightType = callContext.getArgumentDataTypes().get(1).getLogicalType();
        }
        if (!LogicalTypeChecks.areComparable(leftType.getLogicalType(), rightType, StructuredType.StructuredComparison.EQUALS) && !SubQueryInputTypeStrategy.isComparableWithSubQuery(leftType.getLogicalType(), rightType)) {
            return callContext.fail(throwOnFailure, "Types on the right side of IN operator (%s) are not comparable with %s.", rightType, leftType.getLogicalType());
        }
        return Optional.of(Stream.concat(Stream.of(leftType), IntStream.range(1, callContext.getArgumentDataTypes().size()).mapToObj(i -> TypeConversions.fromLogicalToDataType(rightType))).collect(Collectors.toList()));
    }

    private static boolean isComparableWithSubQuery(LogicalType left, LogicalType right) {
        if (right.is(LogicalTypeRoot.ROW) && right.getChildren().size() == 1) {
            RowType rowType = (RowType)right;
            return LogicalTypeChecks.areComparable(left, rowType.getTypeAt(0), StructuredType.StructuredComparison.EQUALS);
        }
        return false;
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        return Arrays.asList(Signature.of(Signature.Argument.ofGroup("COMPARABLE"), Signature.Argument.ofGroupVarying("COMPARABLE")), Signature.of(Signature.Argument.ofGroup("COMPARABLE"), Signature.Argument.ofGroup("SUBQUERY")));
    }
}

