/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
class ExtractInputTypeStrategy
implements InputTypeStrategy {
    ExtractInputTypeStrategy() {
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return ConstantArgumentCount.of(2);
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<DataType> args = callContext.getArgumentDataTypes();
        LogicalType temporalArg = args.get(1).getLogicalType();
        if (!temporalArg.isAnyOf(LogicalTypeFamily.DATETIME, LogicalTypeFamily.INTERVAL)) {
            return callContext.fail(throwOnFailure, "EXTRACT requires 2nd argument to be a temporal type, but type is %s", temporalArg);
        }
        Optional<TimeIntervalUnit> timeIntervalUnit = callContext.getArgumentValue(0, TimeIntervalUnit.class);
        if (!timeIntervalUnit.isPresent()) {
            return callContext.fail(throwOnFailure, "EXTRACT requires 1st argument to be a TimeIntervalUnit literal", new Object[0]);
        }
        switch (timeIntervalUnit.get()) {
            case MILLENNIUM: 
            case CENTURY: 
            case DECADE: 
            case YEAR: 
            case QUARTER: 
            case MONTH: 
            case WEEK: 
            case DAY: 
            case EPOCH: {
                return Optional.of(args);
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case MILLISECOND: 
            case MICROSECOND: 
            case NANOSECOND: {
                if (!temporalArg.isAnyOf(LogicalTypeFamily.TIME, LogicalTypeFamily.TIMESTAMP) && !temporalArg.is(LogicalTypeRoot.INTERVAL_DAY_TIME)) break;
                return Optional.of(args);
            }
        }
        return callContext.fail(throwOnFailure, "EXTRACT does not support TimeIntervalUnit %s for type %s", timeIntervalUnit.get(), temporalArg);
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        return Collections.singletonList(Signature.of(Signature.Argument.ofGroup(TimeIntervalUnit.class), Signature.Argument.ofGroup("TEMPORAL")));
    }
}

