/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.handler.materializedtable.scheduler;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyResponseBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.rest.handler.AbstractSqlGatewayRestHandler;
import org.apache.flink.table.gateway.rest.message.materializedtable.scheduler.EmbeddedSchedulerWorkflowRequestBody;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;
import org.apache.flink.table.gateway.workflow.scheduler.EmbeddedQuartzScheduler;

public class DeleteEmbeddedSchedulerWorkflowHandler
extends AbstractSqlGatewayRestHandler<EmbeddedSchedulerWorkflowRequestBody, EmptyResponseBody, EmptyMessageParameters> {
    private final EmbeddedQuartzScheduler quartzScheduler;

    public DeleteEmbeddedSchedulerWorkflowHandler(SqlGatewayService service, EmbeddedQuartzScheduler quartzScheduler, Map<String, String> responseHeaders, MessageHeaders<EmbeddedSchedulerWorkflowRequestBody, EmptyResponseBody, EmptyMessageParameters> messageHeaders) {
        super(service, responseHeaders, messageHeaders);
        this.quartzScheduler = quartzScheduler;
    }

    @Override
    protected CompletableFuture<EmptyResponseBody> handleRequest(@Nullable SqlGatewayRestAPIVersion version, @Nonnull HandlerRequest<EmbeddedSchedulerWorkflowRequestBody> request) throws RestHandlerException {
        String workflowName = request.getRequestBody().getWorkflowName();
        String workflowGroup = request.getRequestBody().getWorkflowGroup();
        try {
            this.quartzScheduler.deleteScheduleWorkflow(workflowName, workflowGroup);
            return CompletableFuture.completedFuture(EmptyResponseBody.getInstance());
        }
        catch (Exception e) {
            throw new RestHandlerException(e.getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR, e);
        }
    }
}

