/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.util;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.metrics.TimerGauge;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.RelativeClock;

@Internal
@ThreadSafe
public class PausableRelativeClock
implements RelativeClock,
TimerGauge.StartStopListener {
    private final Clock baseClock;
    private long accumulativeBlockedNanoTime;
    private long currentBlockedNanoTimeStart;
    private long pausedCounter;

    public PausableRelativeClock(Clock baseClock) {
        this.baseClock = baseClock;
    }

    @Override
    public long relativeTimeMillis() {
        return this.relativeTimeNanos() / 1000000L;
    }

    @Override
    public synchronized long relativeTimeNanos() {
        long now = this.baseClock.relativeTimeNanos();
        return now - this.getBlockedTime(now);
    }

    private long getBlockedTime(long now) {
        long blockedTime = this.accumulativeBlockedNanoTime;
        if (this.pausedCounter != 0L) {
            blockedTime += now - this.currentBlockedNanoTimeStart;
        }
        return blockedTime;
    }

    public synchronized void pause() {
        if (this.pausedCounter == 0L) {
            this.currentBlockedNanoTimeStart = this.baseClock.relativeTimeNanos();
        }
        ++this.pausedCounter;
    }

    public synchronized void unPause() {
        Preconditions.checkState(this.pausedCounter >= 1L);
        --this.pausedCounter;
        if (this.pausedCounter == 0L) {
            this.accumulativeBlockedNanoTime += this.baseClock.relativeTimeNanos() - this.currentBlockedNanoTimeStart;
        }
    }

    @Override
    public void markStart() {
        this.pause();
    }

    @Override
    public void markEnd() {
        this.unPause();
    }
}

