/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2.adaptor;

import java.util.List;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.common.state.v2.StateIterator;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.runtime.state.v2.adaptor.CompleteStateIterator;

public class OperatorListStateAdaptor<V>
implements org.apache.flink.api.common.state.v2.ListState<V> {
    private final ListState<V> delegatedState;

    public OperatorListStateAdaptor(ListState<V> listState) {
        this.delegatedState = listState;
    }

    @Override
    public StateFuture<Void> asyncUpdate(List<V> values) {
        try {
            this.delegatedState.update(values);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while updating values to raw ListState", e);
        }
        return StateFutureUtils.completedVoidFuture();
    }

    @Override
    public void update(List<V> values) {
        try {
            this.delegatedState.update(values);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while updating values to raw ListState", e);
        }
    }

    @Override
    public StateFuture<Void> asyncAddAll(List<V> values) {
        try {
            this.delegatedState.addAll(values);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while adding values to raw ListState", e);
        }
        return StateFutureUtils.completedVoidFuture();
    }

    @Override
    public void addAll(List<V> values) {
        try {
            this.delegatedState.addAll(values);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while adding values to raw ListState", e);
        }
    }

    @Override
    public StateFuture<StateIterator<V>> asyncGet() {
        try {
            return StateFutureUtils.completedFuture(new CompleteStateIterator((Iterable)this.delegatedState.get()));
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting values from raw ListState", e);
        }
    }

    @Override
    public Iterable<V> get() {
        try {
            return (Iterable)this.delegatedState.get();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting values from raw ListState", e);
        }
    }

    @Override
    public StateFuture<Void> asyncAdd(V value) {
        try {
            this.delegatedState.add(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while adding value to raw ListState", e);
        }
        return StateFutureUtils.completedVoidFuture();
    }

    @Override
    public void add(V value) {
        try {
            this.delegatedState.add(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while adding value to raw ListState", e);
        }
    }

    @Override
    public StateFuture<Void> asyncClear() {
        try {
            this.delegatedState.clear();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while clearing ListState", e);
        }
        return StateFutureUtils.completedVoidFuture();
    }

    @Override
    public void clear() {
        try {
            this.delegatedState.clear();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while clearing ListState", e);
        }
    }
}

