/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.executiongraph.ResultPartitionBytes;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.scheduler.adaptivebatch.AllToAllBlockingResultInfo;
import org.apache.flink.runtime.scheduler.adaptivebatch.BlockingResultInfo;
import org.apache.flink.util.Preconditions;

public class BlockingInputInfo
implements BlockingResultInfo {
    private final BlockingResultInfo blockingResultInfo;
    private final int inputTypeNumber;
    private final boolean interInputsKeysCorrelated;
    private final boolean intraInputKeyCorrelated;

    public BlockingInputInfo(BlockingResultInfo blockingResultInfo, int inputTypeNumber, boolean interInputsKeysCorrelated, boolean intraInputKeyCorrelated) {
        this.blockingResultInfo = Preconditions.checkNotNull(blockingResultInfo);
        this.inputTypeNumber = inputTypeNumber;
        this.interInputsKeysCorrelated = interInputsKeysCorrelated;
        this.intraInputKeyCorrelated = intraInputKeyCorrelated;
    }

    public int getInputTypeNumber() {
        return this.inputTypeNumber;
    }

    public boolean isIntraInputKeyCorrelated() {
        return this.intraInputKeyCorrelated;
    }

    public boolean areInterInputsKeysCorrelated() {
        return this.interInputsKeysCorrelated;
    }

    public List<Long> getAggregatedSubpartitionBytes() {
        Preconditions.checkState(this.blockingResultInfo instanceof AllToAllBlockingResultInfo);
        return ((AllToAllBlockingResultInfo)this.blockingResultInfo).getAggregatedSubpartitionBytes();
    }

    @Override
    public boolean isBroadcast() {
        return this.blockingResultInfo.isBroadcast();
    }

    @Override
    public boolean isPointwise() {
        return this.blockingResultInfo.isPointwise();
    }

    @Override
    public int getNumPartitions() {
        return this.blockingResultInfo.getNumPartitions();
    }

    @Override
    public int getNumSubpartitions(int partitionIndex) {
        return this.blockingResultInfo.getNumSubpartitions(partitionIndex);
    }

    @Override
    public long getNumBytesProduced() {
        return this.blockingResultInfo.getNumBytesProduced();
    }

    @Override
    public long getNumBytesProduced(IndexRange partitionIndexRange, IndexRange subpartitionIndexRange) {
        return this.blockingResultInfo.getNumBytesProduced(partitionIndexRange, subpartitionIndexRange);
    }

    @Override
    public IntermediateDataSetID getResultId() {
        return this.blockingResultInfo.getResultId();
    }

    @Override
    public boolean isSingleSubpartitionContainsAllData() {
        return this.blockingResultInfo.isSingleSubpartitionContainsAllData();
    }

    @Override
    public Map<Integer, long[]> getSubpartitionBytesByPartitionIndex() {
        return this.blockingResultInfo.getSubpartitionBytesByPartitionIndex();
    }

    @Override
    public void recordPartitionInfo(int partitionIndex, ResultPartitionBytes partitionBytes) {
        throw new UnsupportedOperationException("Not allowed to modify read-only view.");
    }

    @Override
    public void resetPartitionInfo(int partitionIndex) {
        throw new UnsupportedOperationException("Not allowed to modify read-only view.");
    }
}

