/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFile;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierMasterAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleDescriptor;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleHandler;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteTierShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleMetrics;
import org.apache.flink.util.Preconditions;

public class RemoteTierMasterAgent
implements TierMasterAgent {
    private final TieredStorageResourceRegistry resourceRegistry;
    private final String remoteStorageBasePath;

    RemoteTierMasterAgent(String remoteStorageBasePath, TieredStorageResourceRegistry resourceRegistry) {
        this.remoteStorageBasePath = remoteStorageBasePath;
        this.resourceRegistry = resourceRegistry;
    }

    @Override
    public void registerJob(JobID jobID, TierShuffleHandler tierShuffleHandler) {
    }

    @Override
    public void unregisterJob(JobID jobID) {
    }

    @Override
    public TierShuffleDescriptor addPartitionAndGetShuffleDescriptor(JobID jobID, int numSubpartitions, ResultPartitionID resultPartitionID) {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId(resultPartitionID);
        this.resourceRegistry.registerResource(partitionId, () -> SegmentPartitionFile.deletePathQuietly(SegmentPartitionFile.getPartitionPath(partitionId, this.remoteStorageBasePath)));
        return new RemoteTierShuffleDescriptor(partitionId);
    }

    @Override
    public CompletableFuture<Map<ResultPartitionID, ShuffleMetrics>> getPartitionWithMetrics(JobID jobId, Duration timeout, Set<ResultPartitionID> expectedPartitions) {
        return CompletableFuture.completedFuture(Collections.emptyMap());
    }

    @Override
    public void releasePartition(TierShuffleDescriptor shuffleDescriptor) {
        Preconditions.checkState(shuffleDescriptor instanceof RemoteTierShuffleDescriptor);
        this.resourceRegistry.clearResourceFor(((RemoteTierShuffleDescriptor)shuffleDescriptor).getPartitionId());
    }

    @Override
    public void close() {
    }

    @Override
    public boolean partitionInRemote() {
        return true;
    }
}

