/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import org.apache.flink.api.common.JobStatus;
import org.apache.flink.shaded.guava32.com.google.common.collect.BiMap;
import org.apache.flink.shaded.guava32.com.google.common.collect.EnumBiMap;

public enum ApplicationStatus {
    SUCCEEDED(0),
    FAILED(1443),
    CANCELED(0),
    UNKNOWN(1445);

    private static final BiMap<JobStatus, ApplicationStatus> JOB_STATUS_APPLICATION_STATUS_BI_MAP;
    private final int processExitCode;

    private ApplicationStatus(int exitCode) {
        this.processExitCode = exitCode;
    }

    public int processExitCode() {
        return this.processExitCode;
    }

    public static ApplicationStatus fromJobStatus(JobStatus jobStatus) {
        return JOB_STATUS_APPLICATION_STATUS_BI_MAP.getOrDefault((Object)jobStatus, UNKNOWN);
    }

    public JobStatus deriveJobStatus() {
        if (!JOB_STATUS_APPLICATION_STATUS_BI_MAP.inverse().containsKey((Object)this)) {
            throw new UnsupportedOperationException(this.name() + " cannot be mapped to a JobStatus.");
        }
        return (JobStatus)((Object)JOB_STATUS_APPLICATION_STATUS_BI_MAP.inverse().get((Object)this));
    }

    static {
        JOB_STATUS_APPLICATION_STATUS_BI_MAP = EnumBiMap.create(JobStatus.class, ApplicationStatus.class);
        JOB_STATUS_APPLICATION_STATUS_BI_MAP.put(JobStatus.FAILED, FAILED);
        JOB_STATUS_APPLICATION_STATUS_BI_MAP.put(JobStatus.CANCELED, CANCELED);
        JOB_STATUS_APPLICATION_STATUS_BI_MAP.put(JobStatus.FINISHED, SUCCEEDED);
    }
}

