/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.filemerging;

import java.io.IOException;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManagerBase;
import org.apache.flink.runtime.checkpoint.filemerging.PhysicalFile;
import org.apache.flink.runtime.checkpoint.filemerging.PhysicalFilePool;
import org.apache.flink.runtime.state.CheckpointedStateScope;

public class AcrossCheckpointFileMergingSnapshotManager
extends FileMergingSnapshotManagerBase {
    private final PhysicalFilePool filePool = this.createPhysicalPool();

    public AcrossCheckpointFileMergingSnapshotManager(String id, long maxFileSize, PhysicalFilePool.Type filePoolType, float maxSpaceAmplification, Executor ioExecutor, MetricGroup metricGroup) {
        super(id, maxFileSize, filePoolType, maxSpaceAmplification, ioExecutor, metricGroup);
    }

    @Override
    @Nonnull
    protected PhysicalFile getOrCreatePhysicalFileForCheckpoint(FileMergingSnapshotManager.SubtaskKey subtaskKey, long checkpointID, CheckpointedStateScope scope) throws IOException {
        return this.filePool.pollFile(subtaskKey, scope);
    }

    @Override
    protected void returnPhysicalFileForNextReuse(FileMergingSnapshotManager.SubtaskKey subtaskKey, long checkpointId, PhysicalFile physicalFile) throws IOException {
        FSDataOutputStream os;
        if (this.shouldSyncAfterClosingLogicalFile && (os = physicalFile.getOutputStream()) != null) {
            os.sync();
        }
        if (!this.filePool.tryPutFile(subtaskKey, physicalFile)) {
            physicalFile.close();
        }
    }
}

