/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobCacheSizeTracker {
    private static final Logger LOG = LoggerFactory.getLogger(BlobCacheSizeTracker.class);
    private static final int INITIAL_SIZE = 10000;
    private final Object lock = new Object();
    protected final long sizeLimit;
    @GuardedBy(value="lock")
    private long total;
    @GuardedBy(value="lock")
    private final LinkedHashMap<Tuple2<JobID, BlobKey>, Long> caches;
    @GuardedBy(value="lock")
    private final HashMap<JobID, Set<BlobKey>> blobKeyByJob;

    public BlobCacheSizeTracker(long sizeLimit) {
        Preconditions.checkArgument(sizeLimit > 0L);
        this.sizeLimit = sizeLimit;
        this.total = 0L;
        this.caches = new LinkedHashMap(10000, 0.75f, true);
        this.blobKeyByJob = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tuple2<JobID, BlobKey>> checkLimit(long size) {
        Preconditions.checkArgument(size >= 0L);
        Object object = this.lock;
        synchronized (object) {
            ArrayList<Tuple2<JobID, BlobKey>> blobsToDelete = new ArrayList<Tuple2<JobID, BlobKey>>();
            long current = this.total;
            for (Map.Entry<Tuple2<JobID, BlobKey>, Long> entry : this.caches.entrySet()) {
                if (current + size <= this.sizeLimit) continue;
                blobsToDelete.add(entry.getKey());
                current -= entry.getValue().longValue();
            }
            return blobsToDelete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track(JobID jobId, BlobKey blobKey, long size) {
        Preconditions.checkNotNull(jobId);
        Preconditions.checkNotNull(blobKey);
        Preconditions.checkArgument(size >= 0L);
        Object object = this.lock;
        synchronized (object) {
            if (this.caches.putIfAbsent(Tuple2.of(jobId, blobKey), size) == null) {
                this.blobKeyByJob.computeIfAbsent(jobId, ignore -> new HashSet()).add(blobKey);
                this.total += size;
                if (this.total > this.sizeLimit) {
                    LOG.warn("The overall size of BLOBs in the cache exceeds the limit. Limit = [{}], Current: [{}], The size of next BLOB: [{}].", new Object[]{this.sizeLimit, this.total, size});
                }
            } else {
                LOG.warn("Attempt to track a duplicated BLOB. This may indicate a duplicate upload or a hash collision. Ignoring newest upload. JobID = [{}], BlobKey = [{}]", (Object)jobId, (Object)blobKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void untrack(Tuple2<JobID, BlobKey> key) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull((JobID)key.f0);
        Preconditions.checkNotNull((BlobKey)key.f1);
        Object object = this.lock;
        synchronized (object) {
            this.blobKeyByJob.computeIfAbsent((JobID)key.f0, ignore -> new HashSet()).remove(key.f1);
            Long size = (Long)this.caches.remove(key);
            if (size != null) {
                Preconditions.checkState(size >= 0L);
                this.total -= size.longValue();
            }
        }
    }

    private void untrack(JobID jobId, BlobKey blobKey) {
        Preconditions.checkNotNull(jobId);
        Preconditions.checkNotNull(blobKey);
        this.untrack(Tuple2.of(jobId, blobKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(JobID jobId, BlobKey blobKey) {
        Preconditions.checkNotNull(jobId);
        Preconditions.checkNotNull(blobKey);
        Object object = this.lock;
        synchronized (object) {
            this.caches.get(Tuple2.of(jobId, blobKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void untrackAll(JobID jobId) {
        Preconditions.checkNotNull(jobId);
        Object object = this.lock;
        synchronized (object) {
            Set<BlobKey> keysToRemove = this.blobKeyByJob.remove(jobId);
            if (keysToRemove != null) {
                for (BlobKey key : keysToRemove) {
                    this.untrack(jobId, key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Long getSize(JobID jobId, BlobKey blobKey) {
        Preconditions.checkNotNull(jobId);
        Preconditions.checkNotNull(blobKey);
        Object object = this.lock;
        synchronized (object) {
            return this.caches.get(Tuple2.of(jobId, blobKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Set<BlobKey> getBlobKeysByJobId(JobID jobId) {
        Preconditions.checkNotNull(jobId);
        Object object = this.lock;
        synchronized (object) {
            return this.blobKeyByJob.getOrDefault(jobId, Collections.emptySet());
        }
    }
}

