/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.state;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.state.InternalStateFuture;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.util.function.BiFunctionWithException;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.ThrowingConsumer;
import org.apache.flink.util.function.ThrowingRunnable;

@Internal
public class StateFutureImpl<T>
implements InternalStateFuture<T> {
    private final CompletableFuture<T> completableFuture = new CompletableFuture();
    protected final CallbackRunner callbackRunner;
    protected final AsyncFrameworkExceptionHandler exceptionHandler;

    public StateFutureImpl(CallbackRunner callbackRunner, AsyncFrameworkExceptionHandler exceptionHandler) {
        this.callbackRunner = callbackRunner;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public <U> StateFuture<U> thenApply(FunctionWithException<? super T, ? extends U, ? extends Exception> fn) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t2;
            try {
                t2 = this.completableFuture.get();
            }
            catch (Exception e2) {
                this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", e2);
                return null;
            }
            U r = FunctionWithException.unchecked(fn).apply(t2);
            this.callbackFinished();
            return StateFutureUtils.completedFuture(r);
        }
        StateFutureImpl ret = this.makeNewStateFuture();
        ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit(() -> {
            ret.completeInCallbackRunner(fn.apply(t));
            this.callbackFinished();
        }))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        });
        return ret;
    }

    @Override
    public StateFuture<Void> thenAccept(ThrowingConsumer<? super T, ? extends Exception> action) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t2;
            try {
                t2 = this.completableFuture.get();
            }
            catch (Exception e2) {
                this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", e2);
                return null;
            }
            ThrowingConsumer.unchecked(action).accept(t2);
            this.callbackFinished();
            return StateFutureUtils.completedVoidFuture();
        }
        StateFutureImpl<Void> ret = this.makeNewStateFuture();
        ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit(() -> {
            action.accept(t);
            ret.completeInCallbackRunner(null);
            this.callbackFinished();
        }))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        });
        return ret;
    }

    @Override
    public <U> StateFuture<U> thenCompose(FunctionWithException<? super T, ? extends StateFuture<U>, ? extends Exception> action) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t2;
            try {
                t2 = this.completableFuture.get();
            }
            catch (Throwable e2) {
                this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", e2);
                return null;
            }
            this.callbackFinished();
            return FunctionWithException.unchecked(action).apply(t2);
        }
        StateFutureImpl ret = this.makeNewStateFuture();
        ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit(() -> {
            StateFuture su = (StateFuture)action.apply(t);
            su.thenAccept(ret::completeInCallbackRunner);
            this.callbackFinished();
        }))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        });
        return ret;
    }

    @Override
    public <U, V> StateFuture<V> thenCombine(StateFuture<? extends U> other, BiFunctionWithException<? super T, ? super U, ? extends V, ? extends Exception> fn) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t;
            try {
                t = this.completableFuture.get();
            }
            catch (Throwable e) {
                this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", e);
                return null;
            }
            return other.thenCompose(u -> {
                Object v = fn.apply((T)t, (Object)u);
                this.callbackFinished();
                return StateFutureUtils.completedFuture(v);
            });
        }
        StateFutureImpl ret = this.makeNewStateFuture();
        ((InternalStateFuture)other).thenSyncAccept(u -> ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit(() -> {
            ret.completeInCallbackRunner(fn.apply(t, u));
            this.callbackFinished();
        }))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        }));
        return ret;
    }

    @Override
    public <U, V> StateFuture<Tuple2<Boolean, Object>> thenConditionallyApply(FunctionWithException<? super T, Boolean, ? extends Exception> condition, FunctionWithException<? super T, ? extends U, ? extends Exception> actionIfTrue, FunctionWithException<? super T, ? extends V, ? extends Exception> actionIfFalse) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t2;
            try {
                t2 = this.completableFuture.get();
            }
            catch (Exception e2) {
                this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", e2);
                return null;
            }
            boolean test = FunctionWithException.unchecked(condition).apply(t2);
            Object r = test ? FunctionWithException.unchecked(actionIfTrue).apply(t2) : FunctionWithException.unchecked(actionIfFalse).apply(t2);
            this.callbackFinished();
            return StateFutureUtils.completedFuture(Tuple2.of(test, r));
        }
        StateFutureImpl<Tuple2<Boolean, Object>> ret = this.makeNewStateFuture();
        ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit(() -> {
            boolean test = (Boolean)condition.apply(t);
            Object r = test ? actionIfTrue.apply(t) : actionIfFalse.apply(t);
            ret.completeInCallbackRunner(Tuple2.of(test, r));
            this.callbackFinished();
        }))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        });
        return ret;
    }

    @Override
    public <U> StateFuture<Tuple2<Boolean, U>> thenConditionallyApply(FunctionWithException<? super T, Boolean, ? extends Exception> condition, FunctionWithException<? super T, ? extends U, ? extends Exception> actionIfTrue) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t2;
            try {
                t2 = this.completableFuture.get();
            }
            catch (Exception e2) {
                this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", e2);
                return null;
            }
            boolean test = FunctionWithException.unchecked(condition).apply(t2);
            Object r = test ? (Object)FunctionWithException.unchecked(actionIfTrue).apply((T)t2) : null;
            this.callbackFinished();
            return StateFutureUtils.completedFuture(Tuple2.of(test, r));
        }
        StateFutureImpl ret = this.makeNewStateFuture();
        ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit(() -> {
            boolean test = (Boolean)condition.apply(t);
            Object r = test ? (Object)actionIfTrue.apply(t) : null;
            ret.completeInCallbackRunner(Tuple2.of(test, r));
            this.callbackFinished();
        }))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        });
        return ret;
    }

    @Override
    public StateFuture<Boolean> thenConditionallyAccept(FunctionWithException<? super T, Boolean, ? extends Exception> condition, ThrowingConsumer<? super T, ? extends Exception> actionIfTrue, ThrowingConsumer<? super T, ? extends Exception> actionIfFalse) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t2;
            try {
                t2 = this.completableFuture.get();
            }
            catch (Exception e2) {
                this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", e2);
                return null;
            }
            boolean test = FunctionWithException.unchecked(condition).apply(t2);
            if (test) {
                ThrowingConsumer.unchecked(actionIfTrue).accept(t2);
            } else {
                ThrowingConsumer.unchecked(actionIfFalse).accept(t2);
            }
            this.callbackFinished();
            return StateFutureUtils.completedFuture(test);
        }
        StateFutureImpl<Boolean> ret = this.makeNewStateFuture();
        ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit(() -> {
            boolean test = (Boolean)condition.apply(t);
            if (test) {
                actionIfTrue.accept(t);
            } else {
                actionIfFalse.accept(t);
            }
            ret.completeInCallbackRunner(test);
            this.callbackFinished();
        }))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        });
        return ret;
    }

    @Override
    public StateFuture<Boolean> thenConditionallyAccept(FunctionWithException<? super T, Boolean, ? extends Exception> condition, ThrowingConsumer<? super T, ? extends Exception> actionIfTrue) {
        return this.thenConditionallyAccept(condition, actionIfTrue, b -> {});
    }

    @Override
    public <U, V> StateFuture<Tuple2<Boolean, Object>> thenConditionallyCompose(FunctionWithException<? super T, Boolean, ? extends Exception> condition, FunctionWithException<? super T, ? extends StateFuture<U>, ? extends Exception> actionIfTrue, FunctionWithException<? super T, ? extends StateFuture<V>, ? extends Exception> actionIfFalse) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t2;
            try {
                t2 = this.completableFuture.get();
            }
            catch (Throwable e2) {
                this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", e2);
                return null;
            }
            boolean test = FunctionWithException.unchecked(condition).apply(t2);
            StateFuture<Object> actionResult = test ? FunctionWithException.unchecked(actionIfTrue).apply(t2) : FunctionWithException.unchecked(actionIfFalse).apply(t2);
            StateFutureImpl<Tuple2<Boolean, Object>> ret = this.makeNewStateFuture();
            actionResult.thenAccept(e -> ret.completeInCallbackRunner(Tuple2.of(test, e)));
            this.callbackFinished();
            return ret;
        }
        StateFutureImpl<Tuple2<Boolean, Object>> ret = this.makeNewStateFuture();
        ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit(() -> {
            boolean test = (Boolean)condition.apply(t);
            StateFuture actionResult = test ? (StateFuture)actionIfTrue.apply(t) : (StateFuture)actionIfFalse.apply(t);
            actionResult.thenAccept(e -> ret.completeInCallbackRunner(Tuple2.of(test, e)));
            this.callbackFinished();
        }))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        });
        return ret;
    }

    @Override
    public <U> StateFuture<Tuple2<Boolean, U>> thenConditionallyCompose(FunctionWithException<? super T, Boolean, ? extends Exception> condition, FunctionWithException<? super T, ? extends StateFuture<U>, ? extends Exception> actionIfTrue) {
        this.callbackRegistered();
        if (this.completableFuture.isDone()) {
            T t2;
            try {
                t2 = this.completableFuture.get();
            }
            catch (Throwable e2) {
                this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", e2);
                return null;
            }
            boolean test = FunctionWithException.unchecked(condition).apply(t2);
            if (test) {
                StateFuture<U> actionResult = FunctionWithException.unchecked(actionIfTrue).apply(t2);
                StateFutureImpl ret = this.makeNewStateFuture();
                actionResult.thenAccept(e -> ret.completeInCallbackRunner(Tuple2.of(true, e)));
                this.callbackFinished();
                return ret;
            }
            this.callbackFinished();
            return StateFutureUtils.completedFuture(Tuple2.of(false, null));
        }
        StateFutureImpl ret = this.makeNewStateFuture();
        ((CompletableFuture)this.completableFuture.thenAccept(t -> this.callbackRunner.submit(() -> {
            boolean test = (Boolean)condition.apply(t);
            if (test) {
                StateFuture actionResult = (StateFuture)actionIfTrue.apply(t);
                actionResult.thenAccept(e -> ret.completeInCallbackRunner(Tuple2.of(true, e)));
            } else {
                ret.completeInCallbackRunner(Tuple2.of(false, null));
            }
            this.callbackFinished();
        }))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when submitting StateFuture's callback.", (Throwable)e);
            return null;
        });
        return ret;
    }

    public <A> StateFutureImpl<A> makeNewStateFuture() {
        return new StateFutureImpl<T>(this.callbackRunner, this.exceptionHandler);
    }

    @Override
    public boolean isDone() {
        return this.completableFuture.isDone();
    }

    @Override
    public T get() {
        T t;
        try {
            t = this.completableFuture.get();
        }
        catch (Exception e) {
            this.exceptionHandler.handleException("Caught exception when getting StateFuture's result.", e);
            return null;
        }
        return t;
    }

    @Override
    public void complete(T result) {
        if (this.completableFuture.isCompletedExceptionally()) {
            throw new IllegalStateException("StateFuture already failed !");
        }
        this.completableFuture.complete(result);
        this.postComplete(false);
    }

    @Override
    public void completeExceptionally(String message, Throwable ex) {
        this.exceptionHandler.handleException(message, ex);
    }

    private void completeInCallbackRunner(T result) {
        this.completableFuture.complete(result);
        this.postComplete(true);
    }

    public void callbackRegistered() {
    }

    public void postComplete(boolean inCallbackRunner) {
    }

    public void callbackFinished() {
    }

    @Override
    public void thenSyncAccept(ThrowingConsumer<? super T, ? extends Exception> action) {
        ((CompletableFuture)this.completableFuture.thenAccept((Consumer)ThrowingConsumer.unchecked(action))).exceptionally(e -> {
            this.exceptionHandler.handleException("Caught exception when processing completed StateFuture's callback.", (Throwable)e);
            return null;
        });
    }

    public static interface AsyncFrameworkExceptionHandler {
        public void handleException(String var1, Throwable var2);
    }

    public static interface CallbackRunner {
        public void submit(ThrowingRunnable<? extends Exception> var1);
    }
}

