/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program.rest;

import java.util.Collection;
import org.apache.flink.runtime.rest.HttpMethodWrapper;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.versioning.RestAPIVersion;
import org.apache.flink.shaded.guava32.com.google.common.base.Preconditions;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;

public class UrlPrefixDecorator<R extends RequestBody, P extends ResponseBody, M extends MessageParameters>
implements MessageHeaders<R, P, M> {
    private final String prefixedUrl;
    private final MessageHeaders<R, P, M> decorated;

    public UrlPrefixDecorator(MessageHeaders<R, P, M> messageHeaders, String urlPrefix) {
        Preconditions.checkNotNull(messageHeaders);
        Preconditions.checkNotNull(urlPrefix);
        this.decorated = messageHeaders;
        this.prefixedUrl = UrlPrefixDecorator.constructPrefixedUrlWithVersionPlaceholder(urlPrefix, messageHeaders.getTargetRestEndpointURL());
    }

    private static String constructPrefixedUrlWithVersionPlaceholder(String urlPrefix, String targetRestEndpointURL) {
        return urlPrefix + "/{{VERSION}}" + targetRestEndpointURL;
    }

    @Override
    public HttpMethodWrapper getHttpMethod() {
        return this.decorated.getHttpMethod();
    }

    @Override
    public String getTargetRestEndpointURL() {
        return this.prefixedUrl;
    }

    @Override
    public Class<P> getResponseClass() {
        return this.decorated.getResponseClass();
    }

    @Override
    public HttpResponseStatus getResponseStatusCode() {
        return this.decorated.getResponseStatusCode();
    }

    @Override
    public String getDescription() {
        return this.decorated.getDescription();
    }

    @Override
    public Class<R> getRequestClass() {
        return this.decorated.getRequestClass();
    }

    @Override
    public M getUnresolvedMessageParameters() {
        return this.decorated.getUnresolvedMessageParameters();
    }

    @Override
    public Collection<? extends RestAPIVersion<?>> getSupportedAPIVersions() {
        return this.decorated.getSupportedAPIVersions();
    }

    @Override
    public Collection<Class<?>> getResponseTypeParameters() {
        return this.decorated.getResponseTypeParameters();
    }

    public MessageHeaders<R, P, M> getDecorated() {
        return this.decorated;
    }
}

