/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.LinkedHashMap;
import java.util.Optional;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractionUtils;
import org.apache.flink.api.java.typeutils.runtime.KryoRegistration;
import org.apache.flink.api.java.typeutils.runtime.kryo.Serializers;

public abstract class AvroUtils {
    private static final String AVRO_KRYO_UTILS = "org.apache.flink.formats.avro.utils.AvroKryoSerializerUtils";
    protected static final String AVRO_SPECIFIC_RECORD_BASE_CLASS = "org.apache.avro.specific.SpecificRecordBase";

    public static AvroUtils getAvroUtils() {
        try {
            Class<?> clazz = Class.forName(AVRO_KRYO_UTILS, false, Thread.currentThread().getContextClassLoader());
            return clazz.asSubclass(AvroUtils.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return new DefaultAvroUtils();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate org.apache.flink.formats.avro.utils.AvroKryoSerializerUtils.", e);
        }
    }

    public static Optional<AvroUtils> tryGetAvroUtils() {
        try {
            Class<?> clazz = Class.forName(AVRO_KRYO_UTILS, false, Thread.currentThread().getContextClassLoader());
            return Optional.of(clazz.asSubclass(AvroUtils.class).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate org.apache.flink.formats.avro.utils.AvroKryoSerializerUtils.", e);
        }
    }

    public static boolean isAvroSpecificRecord(Class<?> clazz) {
        return TypeExtractionUtils.hasSuperclass(clazz, AVRO_SPECIFIC_RECORD_BASE_CLASS);
    }

    public abstract void addAvroSerializersIfRequired(SerializerConfig var1, Class<?> var2);

    public abstract void addAvroGenericDataArrayRegistration(LinkedHashMap<String, KryoRegistration> var1);

    public abstract <T> TypeSerializer<T> createAvroSerializer(Class<T> var1);

    public abstract <T> TypeInformation<T> createAvroTypeInfo(Class<T> var1);

    private static class DefaultAvroUtils
    extends AvroUtils {
        private static final String AVRO_GENERIC_RECORD = "org.apache.avro.generic.GenericData$Record";
        private static final String AVRO_GENERIC_DATA_ARRAY = "org.apache.avro.generic.GenericData$Array";

        private DefaultAvroUtils() {
        }

        @Override
        public void addAvroSerializersIfRequired(SerializerConfig reg, Class<?> type) {
            if (TypeExtractionUtils.hasSuperclass(type, AvroUtils.AVRO_SPECIFIC_RECORD_BASE_CLASS) || TypeExtractionUtils.hasSuperclass(type, AVRO_GENERIC_RECORD)) {
                throw new RuntimeException("Could not load class 'org.apache.flink.formats.avro.utils.AvroKryoSerializerUtils'. You may be missing the 'flink-avro' dependency.");
            }
        }

        @Override
        public void addAvroGenericDataArrayRegistration(LinkedHashMap<String, KryoRegistration> kryoRegistrations) {
            kryoRegistrations.put(AVRO_GENERIC_DATA_ARRAY, new KryoRegistration(Serializers.DummyAvroRegisteredClass.class, Serializers.DummyAvroKryoSerializerClass.class));
        }

        @Override
        public <T> TypeSerializer<T> createAvroSerializer(Class<T> type) {
            throw new RuntimeException("Could not load the AvroSerializer class. You may be missing the 'flink-avro' dependency.");
        }

        @Override
        public <T> TypeInformation<T> createAvroTypeInfo(Class<T> type) {
            throw new RuntimeException("Could not load the AvroTypeInfo class. You may be missing the 'flink-avro' dependency.");
        }
    }
}

