/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.StateTypeStrategy;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.util.Preconditions;

@Internal
class DefaultStateTypeStrategy
implements StateTypeStrategy {
    private final TypeStrategy typeStrategy;

    DefaultStateTypeStrategy(TypeStrategy typeStrategy) {
        this.typeStrategy = Preconditions.checkNotNull(typeStrategy, "Type strategy must not be null.");
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        return this.typeStrategy.inferType(callContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DefaultStateTypeStrategy) {
            return Objects.equals(this.typeStrategy, ((DefaultStateTypeStrategy)o).typeStrategy);
        }
        if (o instanceof TypeStrategy) {
            return Objects.equals(this.typeStrategy, o);
        }
        return false;
    }

    public int hashCode() {
        return this.typeStrategy.hashCode();
    }
}

