/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataview;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.dataview.MapViewSerializer;
import org.apache.flink.table.dataview.NullAwareMapSerializer;
import org.apache.flink.table.dataview.NullSerializer;

@Deprecated
@Internal
public class MapViewTypeInfo<K, V>
extends TypeInformation<MapView<K, V>> {
    private static final long serialVersionUID = -2883944144965318259L;
    private final TypeInformation<K> keyType;
    private final TypeInformation<V> valueType;
    private final boolean nullAware;
    private boolean nullSerializer;

    public MapViewTypeInfo(TypeInformation<K> keyType, TypeInformation<V> valueType, boolean nullSerializer, boolean nullAware) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.nullSerializer = nullSerializer;
        this.nullAware = nullAware;
    }

    public MapViewTypeInfo(TypeInformation<K> keyType, TypeInformation<V> valueType) {
        this(keyType, valueType, false, false);
    }

    public TypeInformation<K> getKeyType() {
        return this.keyType;
    }

    public TypeInformation<V> getValueType() {
        return this.valueType;
    }

    public boolean isNullAware() {
        return this.nullAware;
    }

    public boolean isNullSerializer() {
        return this.nullSerializer;
    }

    public void setNullSerializer(boolean nullSerializer) {
        this.nullSerializer = nullSerializer;
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public int getTotalFields() {
        return 1;
    }

    @Override
    public Class<MapView<K, V>> getTypeClass() {
        return MapView.class;
    }

    @Override
    public boolean isKeyType() {
        return false;
    }

    @Override
    public TypeSerializer<MapView<K, V>> createSerializer(SerializerConfig config) {
        if (this.nullSerializer) {
            return NullSerializer.INSTANCE;
        }
        TypeSerializer<K> keySer = this.keyType.createSerializer(config);
        TypeSerializer<V> valueSer = this.valueType.createSerializer(config);
        if (this.nullAware) {
            return new MapViewSerializer(new NullAwareMapSerializer<K, V>(keySer, valueSer));
        }
        return new MapViewSerializer(new MapSerializer<K, V>(keySer, valueSer));
    }

    @Override
    public String toString() {
        return "MapView<" + this.keyType + ", " + this.valueType + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MapViewTypeInfo) {
            MapViewTypeInfo other = (MapViewTypeInfo)obj;
            return this.keyType.equals(other.keyType) && this.valueType.equals(other.valueType) && this.nullSerializer == other.nullSerializer && this.nullAware == other.nullAware;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keyType, this.valueType, this.nullSerializer, this.nullAware);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

