/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.threadinfo;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.messages.ThreadInfoSample;
import org.apache.flink.runtime.taskexecutor.TaskExecutorThreadInfoGateway;
import org.apache.flink.runtime.webmonitor.stats.TaskStatsRequestCoordinator;
import org.apache.flink.runtime.webmonitor.threadinfo.ThreadInfoSamplesRequest;
import org.apache.flink.runtime.webmonitor.threadinfo.VertexThreadInfoStats;
import org.apache.flink.shaded.guava32.com.google.common.collect.ImmutableSet;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;

public class ThreadInfoRequestCoordinator
extends TaskStatsRequestCoordinator<Map<ExecutionAttemptID, Collection<ThreadInfoSample>>, VertexThreadInfoStats> {
    public ThreadInfoRequestCoordinator(Executor executor, Duration requestTimeout) {
        super(executor, requestTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<VertexThreadInfoStats> triggerThreadInfoRequest(Map<ImmutableSet<ExecutionAttemptID>, CompletableFuture<TaskExecutorThreadInfoGateway>> executionsWithGateways, int numSamples, Duration delayBetweenSamples, int maxStackTraceDepth) {
        Preconditions.checkNotNull(executionsWithGateways, "Tasks to sample");
        Preconditions.checkArgument(executionsWithGateways.size() > 0, "No tasks to sample");
        Preconditions.checkArgument(numSamples >= 1, "No number of samples");
        Preconditions.checkArgument(maxStackTraceDepth >= 0, "Negative maximum stack trace depth");
        Set<ImmutableSet<ExecutionAttemptID>> runningSubtasksIds = executionsWithGateways.keySet();
        Object object = this.lock;
        synchronized (object) {
            if (this.isShutDown) {
                return FutureUtils.completedExceptionally(new IllegalStateException("Shut down"));
            }
            int requestId = this.requestIdCounter++;
            this.log.debug("Triggering thread info request {}", (Object)requestId);
            PendingThreadInfoRequest pending = new PendingThreadInfoRequest(requestId, runningSubtasksIds);
            long expectedDuration = (long)numSamples * delayBetweenSamples.toMillis();
            Duration timeout = this.requestTimeout.plusMillis(expectedDuration);
            this.pendingRequests.put(requestId, pending);
            ThreadInfoSamplesRequest requestParams = new ThreadInfoSamplesRequest(requestId, numSamples, delayBetweenSamples, maxStackTraceDepth);
            this.requestThreadInfo(executionsWithGateways, requestParams, timeout);
            return pending.getStatsFuture();
        }
    }

    private void requestThreadInfo(Map<ImmutableSet<ExecutionAttemptID>, CompletableFuture<TaskExecutorThreadInfoGateway>> executionWithGateways, ThreadInfoSamplesRequest requestParams, Duration timeout) {
        for (Map.Entry<ImmutableSet<ExecutionAttemptID>, CompletableFuture<TaskExecutorThreadInfoGateway>> executionWithGateway : executionWithGateways.entrySet()) {
            CompletableFuture<TaskExecutorThreadInfoGateway> executorGatewayFuture = executionWithGateway.getValue();
            CompletionStage threadInfo = executorGatewayFuture.thenCompose(executorGateway -> executorGateway.requestThreadInfoSamples((Collection)executionWithGateway.getKey(), requestParams, timeout));
            ((CompletableFuture)threadInfo).whenCompleteAsync((threadInfoSamplesResponse, throwable) -> {
                if (threadInfoSamplesResponse != null) {
                    this.handleSuccessfulResponse(requestParams.getRequestId(), (ImmutableSet)executionWithGateway.getKey(), threadInfoSamplesResponse.getSamples());
                } else {
                    this.handleFailedResponse(requestParams.getRequestId(), (Throwable)throwable);
                }
            }, this.executor);
        }
    }

    private static class PendingThreadInfoRequest
    extends TaskStatsRequestCoordinator.PendingStatsRequest<Map<ExecutionAttemptID, Collection<ThreadInfoSample>>, VertexThreadInfoStats> {
        PendingThreadInfoRequest(int requestId, Collection<? extends Set<ExecutionAttemptID>> tasksToCollect) {
            super(requestId, tasksToCollect);
        }

        @Override
        protected VertexThreadInfoStats assembleCompleteStats(long endTime) {
            HashMap<ExecutionAttemptID, Collection<ThreadInfoSample>> samples = new HashMap<ExecutionAttemptID, Collection<ThreadInfoSample>>();
            for (Map map : this.statsResultByTaskGroup.values()) {
                samples.putAll(map);
            }
            return new VertexThreadInfoStats(this.requestId, this.startTime, endTime, samples);
        }
    }
}

