/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.config.memory.taskmanager;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.util.config.memory.FlinkMemoryUtils;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryUtils;
import org.apache.flink.runtime.util.config.memory.RangeFraction;
import org.apache.flink.runtime.util.config.memory.taskmanager.TaskExecutorFlinkMemory;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutorFlinkMemoryUtils
implements FlinkMemoryUtils<TaskExecutorFlinkMemory> {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutorFlinkMemoryUtils.class);

    @Override
    public TaskExecutorFlinkMemory deriveFromRequiredFineGrainedOptions(Configuration config) {
        MemorySize networkMemorySize;
        MemorySize taskHeapMemorySize = TaskExecutorFlinkMemoryUtils.getTaskHeapMemorySize(config);
        MemorySize managedMemorySize = TaskExecutorFlinkMemoryUtils.getManagedMemorySize(config);
        MemorySize frameworkHeapMemorySize = TaskExecutorFlinkMemoryUtils.getFrameworkHeapMemorySize(config);
        MemorySize frameworkOffHeapMemorySize = TaskExecutorFlinkMemoryUtils.getFrameworkOffHeapMemorySize(config);
        MemorySize taskOffHeapMemorySize = TaskExecutorFlinkMemoryUtils.getTaskOffHeapMemorySize(config);
        MemorySize totalFlinkExcludeNetworkMemorySize = frameworkHeapMemorySize.add(frameworkOffHeapMemorySize).add(taskHeapMemorySize).add(taskOffHeapMemorySize).add(managedMemorySize);
        if (TaskExecutorFlinkMemoryUtils.isTotalFlinkMemorySizeExplicitlyConfigured(config)) {
            MemorySize totalFlinkMemorySize = TaskExecutorFlinkMemoryUtils.getTotalFlinkMemorySize(config);
            if (totalFlinkExcludeNetworkMemorySize.getBytes() > totalFlinkMemorySize.getBytes()) {
                throw new IllegalConfigurationException("Sum of configured Framework Heap Memory (" + frameworkHeapMemorySize.toHumanReadableString() + "), Framework Off-Heap Memory (" + frameworkOffHeapMemorySize.toHumanReadableString() + "), Task Heap Memory (" + taskHeapMemorySize.toHumanReadableString() + "), Task Off-Heap Memory (" + taskOffHeapMemorySize.toHumanReadableString() + ") and Managed Memory (" + managedMemorySize.toHumanReadableString() + ") exceed configured Total Flink Memory (" + totalFlinkMemorySize.toHumanReadableString() + ").");
            }
            networkMemorySize = totalFlinkMemorySize.subtract(totalFlinkExcludeNetworkMemorySize);
            TaskExecutorFlinkMemoryUtils.sanityCheckNetworkMemoryWithExplicitlySetTotalFlinkAndHeapMemory(config, networkMemorySize, totalFlinkMemorySize);
        } else {
            networkMemorySize = TaskExecutorFlinkMemoryUtils.deriveNetworkMemoryWithInverseFraction(config, totalFlinkExcludeNetworkMemorySize);
        }
        TaskExecutorFlinkMemory flinkInternalMemory = new TaskExecutorFlinkMemory(frameworkHeapMemorySize, frameworkOffHeapMemorySize, taskHeapMemorySize, taskOffHeapMemorySize, networkMemorySize, managedMemorySize);
        TaskExecutorFlinkMemoryUtils.sanityCheckTotalFlinkMemory(config, flinkInternalMemory);
        return flinkInternalMemory;
    }

    @Override
    public TaskExecutorFlinkMemory deriveFromTotalFlinkMemory(Configuration config, MemorySize totalFlinkMemorySize) {
        MemorySize networkMemorySize;
        MemorySize managedMemorySize;
        MemorySize taskHeapMemorySize;
        MemorySize frameworkHeapMemorySize = TaskExecutorFlinkMemoryUtils.getFrameworkHeapMemorySize(config);
        MemorySize frameworkOffHeapMemorySize = TaskExecutorFlinkMemoryUtils.getFrameworkOffHeapMemorySize(config);
        MemorySize taskOffHeapMemorySize = TaskExecutorFlinkMemoryUtils.getTaskOffHeapMemorySize(config);
        if (TaskExecutorFlinkMemoryUtils.isTaskHeapMemorySizeExplicitlyConfigured(config)) {
            taskHeapMemorySize = TaskExecutorFlinkMemoryUtils.getTaskHeapMemorySize(config);
            managedMemorySize = TaskExecutorFlinkMemoryUtils.deriveManagedMemoryAbsoluteOrWithFraction(config, totalFlinkMemorySize);
            MemorySize totalFlinkExcludeNetworkMemorySize = frameworkHeapMemorySize.add(frameworkOffHeapMemorySize).add(taskHeapMemorySize).add(taskOffHeapMemorySize).add(managedMemorySize);
            if (totalFlinkExcludeNetworkMemorySize.getBytes() > totalFlinkMemorySize.getBytes()) {
                throw new IllegalConfigurationException("Sum of configured Framework Heap Memory (" + frameworkHeapMemorySize.toHumanReadableString() + "), Framework Off-Heap Memory (" + frameworkOffHeapMemorySize.toHumanReadableString() + "), Task Heap Memory (" + taskHeapMemorySize.toHumanReadableString() + "), Task Off-Heap Memory (" + taskOffHeapMemorySize.toHumanReadableString() + ") and Managed Memory (" + managedMemorySize.toHumanReadableString() + ") exceed configured Total Flink Memory (" + totalFlinkMemorySize.toHumanReadableString() + ").");
            }
            networkMemorySize = totalFlinkMemorySize.subtract(totalFlinkExcludeNetworkMemorySize);
            TaskExecutorFlinkMemoryUtils.sanityCheckNetworkMemoryWithExplicitlySetTotalFlinkAndHeapMemory(config, networkMemorySize, totalFlinkMemorySize);
        } else {
            managedMemorySize = TaskExecutorFlinkMemoryUtils.deriveManagedMemoryAbsoluteOrWithFraction(config, totalFlinkMemorySize);
            networkMemorySize = TaskExecutorFlinkMemoryUtils.deriveNetworkMemoryWithFraction(config, totalFlinkMemorySize);
            MemorySize totalFlinkExcludeTaskHeapMemorySize = frameworkHeapMemorySize.add(frameworkOffHeapMemorySize).add(taskOffHeapMemorySize).add(managedMemorySize).add(networkMemorySize);
            if (totalFlinkExcludeTaskHeapMemorySize.getBytes() > totalFlinkMemorySize.getBytes()) {
                throw new IllegalConfigurationException("Sum of configured Framework Heap Memory (" + frameworkHeapMemorySize.toHumanReadableString() + "), Framework Off-Heap Memory (" + frameworkOffHeapMemorySize.toHumanReadableString() + "), Task Off-Heap Memory (" + taskOffHeapMemorySize.toHumanReadableString() + "), Managed Memory (" + managedMemorySize.toHumanReadableString() + ") and Network Memory (" + networkMemorySize.toHumanReadableString() + ") exceed configured Total Flink Memory (" + totalFlinkMemorySize.toHumanReadableString() + ").");
            }
            taskHeapMemorySize = totalFlinkMemorySize.subtract(totalFlinkExcludeTaskHeapMemorySize);
        }
        TaskExecutorFlinkMemory flinkInternalMemory = new TaskExecutorFlinkMemory(frameworkHeapMemorySize, frameworkOffHeapMemorySize, taskHeapMemorySize, taskOffHeapMemorySize, networkMemorySize, managedMemorySize);
        TaskExecutorFlinkMemoryUtils.sanityCheckTotalFlinkMemory(config, flinkInternalMemory);
        return flinkInternalMemory;
    }

    private static MemorySize deriveManagedMemoryAbsoluteOrWithFraction(Configuration config, MemorySize base) {
        return TaskExecutorFlinkMemoryUtils.isManagedMemorySizeExplicitlyConfigured(config) ? TaskExecutorFlinkMemoryUtils.getManagedMemorySize(config) : ProcessMemoryUtils.deriveWithFraction("managed memory", base, TaskExecutorFlinkMemoryUtils.getManagedMemoryRangeFraction(config));
    }

    private static MemorySize deriveNetworkMemoryWithFraction(Configuration config, MemorySize base) {
        return ProcessMemoryUtils.deriveWithFraction("network memory", base, TaskExecutorFlinkMemoryUtils.getNetworkMemoryRangeFraction(config));
    }

    private static MemorySize deriveNetworkMemoryWithInverseFraction(Configuration config, MemorySize base) {
        return ProcessMemoryUtils.deriveWithInverseFraction("network memory", base, TaskExecutorFlinkMemoryUtils.getNetworkMemoryRangeFraction(config));
    }

    public static MemorySize getFrameworkHeapMemorySize(Configuration config) {
        return ProcessMemoryUtils.getMemorySizeFromConfig(config, TaskManagerOptions.FRAMEWORK_HEAP_MEMORY);
    }

    public static MemorySize getFrameworkOffHeapMemorySize(Configuration config) {
        return ProcessMemoryUtils.getMemorySizeFromConfig(config, TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY);
    }

    private static MemorySize getTaskHeapMemorySize(Configuration config) {
        Preconditions.checkArgument(TaskExecutorFlinkMemoryUtils.isTaskHeapMemorySizeExplicitlyConfigured(config));
        return ProcessMemoryUtils.getMemorySizeFromConfig(config, TaskManagerOptions.TASK_HEAP_MEMORY);
    }

    private static MemorySize getTaskOffHeapMemorySize(Configuration config) {
        return ProcessMemoryUtils.getMemorySizeFromConfig(config, TaskManagerOptions.TASK_OFF_HEAP_MEMORY);
    }

    private static MemorySize getManagedMemorySize(Configuration config) {
        Preconditions.checkArgument(TaskExecutorFlinkMemoryUtils.isManagedMemorySizeExplicitlyConfigured(config));
        return ProcessMemoryUtils.getMemorySizeFromConfig(config, TaskManagerOptions.MANAGED_MEMORY_SIZE);
    }

    private static RangeFraction getManagedMemoryRangeFraction(Configuration config) {
        return ProcessMemoryUtils.getRangeFraction(MemorySize.ZERO, MemorySize.MAX_VALUE, TaskManagerOptions.MANAGED_MEMORY_FRACTION, config);
    }

    private static RangeFraction getNetworkMemoryRangeFraction(Configuration config) {
        MemorySize minSize = ProcessMemoryUtils.getMemorySizeFromConfig(config, TaskManagerOptions.NETWORK_MEMORY_MIN);
        MemorySize maxSize = ProcessMemoryUtils.getMemorySizeFromConfig(config, TaskManagerOptions.NETWORK_MEMORY_MAX);
        return ProcessMemoryUtils.getRangeFraction(minSize, maxSize, TaskManagerOptions.NETWORK_MEMORY_FRACTION, config);
    }

    private static MemorySize getTotalFlinkMemorySize(Configuration config) {
        Preconditions.checkArgument(TaskExecutorFlinkMemoryUtils.isTotalFlinkMemorySizeExplicitlyConfigured(config));
        return ProcessMemoryUtils.getMemorySizeFromConfig(config, TaskManagerOptions.TOTAL_FLINK_MEMORY);
    }

    private static boolean isTaskHeapMemorySizeExplicitlyConfigured(Configuration config) {
        return config.contains(TaskManagerOptions.TASK_HEAP_MEMORY);
    }

    private static boolean isManagedMemorySizeExplicitlyConfigured(Configuration config) {
        return config.contains(TaskManagerOptions.MANAGED_MEMORY_SIZE);
    }

    private static boolean isNetworkMemoryFractionExplicitlyConfigured(Configuration config) {
        return config.contains(TaskManagerOptions.NETWORK_MEMORY_FRACTION);
    }

    private static boolean isTotalFlinkMemorySizeExplicitlyConfigured(Configuration config) {
        return config.contains(TaskManagerOptions.TOTAL_FLINK_MEMORY);
    }

    private static void sanityCheckTotalFlinkMemory(Configuration config, TaskExecutorFlinkMemory flinkInternalMemory) {
        MemorySize configuredTotalFlinkMemorySize;
        if (TaskExecutorFlinkMemoryUtils.isTotalFlinkMemorySizeExplicitlyConfigured(config) && !(configuredTotalFlinkMemorySize = TaskExecutorFlinkMemoryUtils.getTotalFlinkMemorySize(config)).equals(flinkInternalMemory.getTotalFlinkMemorySize())) {
            throw new IllegalConfigurationException("Configured and Derived Flink internal memory sizes (total " + flinkInternalMemory.getTotalFlinkMemorySize().toHumanReadableString() + ") do not add up to the configured Total Flink Memory size (" + configuredTotalFlinkMemorySize.toHumanReadableString() + "). Configured and Derived Flink internal memory sizes are: Framework Heap Memory (" + flinkInternalMemory.getFrameworkHeap().toHumanReadableString() + "), Framework Off-Heap Memory (" + flinkInternalMemory.getFrameworkOffHeap().toHumanReadableString() + "), Task Heap Memory (" + flinkInternalMemory.getTaskHeap().toHumanReadableString() + "), Task Off-Heap Memory (" + flinkInternalMemory.getTaskOffHeap().toHumanReadableString() + "), Network Memory (" + flinkInternalMemory.getNetwork().toHumanReadableString() + "), Managed Memory (" + flinkInternalMemory.getManaged().toHumanReadableString() + ").");
        }
    }

    private static void sanityCheckNetworkMemoryWithExplicitlySetTotalFlinkAndHeapMemory(Configuration config, MemorySize derivedNetworkMemorySize, MemorySize totalFlinkMemorySize) {
        try {
            TaskExecutorFlinkMemoryUtils.sanityCheckNetworkMemory(config, derivedNetworkMemorySize, totalFlinkMemorySize);
        }
        catch (IllegalConfigurationException e) {
            throw new IllegalConfigurationException("If Total Flink, Task Heap and (or) Managed Memory sizes are explicitly configured then the Network Memory size is the rest of the Total Flink memory after subtracting all other configured types of memory, but the derived Network Memory is inconsistent with its configuration.", e);
        }
    }

    private static void sanityCheckNetworkMemory(Configuration config, MemorySize derivedNetworkMemorySize, MemorySize totalFlinkMemorySize) {
        RangeFraction networkRangeFraction = TaskExecutorFlinkMemoryUtils.getNetworkMemoryRangeFraction(config);
        if (derivedNetworkMemorySize.getBytes() > networkRangeFraction.getMaxSize().getBytes() || derivedNetworkMemorySize.getBytes() < networkRangeFraction.getMinSize().getBytes()) {
            throw new IllegalConfigurationException("Derived Network Memory size (" + derivedNetworkMemorySize.toHumanReadableString() + ") is not in configured Network Memory range [" + networkRangeFraction.getMinSize().toHumanReadableString() + ", " + networkRangeFraction.getMaxSize().toHumanReadableString() + "].");
        }
        if (TaskExecutorFlinkMemoryUtils.isNetworkMemoryFractionExplicitlyConfigured(config) && !derivedNetworkMemorySize.equals(totalFlinkMemorySize.multiply(networkRangeFraction.getFraction()))) {
            LOG.info("The derived Network Memory size ({}) does not match the configured Network Memory fraction ({}) from the configured Total Flink Memory size ({}). The derived Network Memory size will be used.", new Object[]{derivedNetworkMemorySize.toHumanReadableString(), networkRangeFraction.getFraction(), totalFlinkMemorySize.toHumanReadableString()});
        }
    }
}

