/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.PathsCopyingFileSystem;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.CheckpointStateToolset;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.NotDuplicatingCheckpointStateToolset;
import org.apache.flink.runtime.state.filesystem.AbstractFsCheckpointStorageAccess;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStateToolset;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStorageLocation;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStreamFactory;
import org.apache.flink.runtime.state.filesystem.FsMergingCheckpointStorageAccess;
import org.apache.flink.util.Preconditions;

public class FsCheckpointStorageAccess
extends AbstractFsCheckpointStorageAccess {
    protected final FileSystem fileSystem;
    protected final Path checkpointsDirectory;
    protected final Path sharedStateDirectory;
    protected final Path taskOwnedStateDirectory;
    protected final int fileSizeThreshold;
    protected final int writeBufferSize;
    private boolean baseLocationsInitialized = false;

    public FsCheckpointStorageAccess(Path checkpointBaseDirectory, @Nullable Path defaultSavepointDirectory, JobID jobId, int fileSizeThreshold, int writeBufferSize) throws IOException {
        this(checkpointBaseDirectory.getFileSystem(), checkpointBaseDirectory, defaultSavepointDirectory, true, jobId, fileSizeThreshold, writeBufferSize);
    }

    public FsCheckpointStorageAccess(Path checkpointBaseDirectory, @Nullable Path defaultSavepointDirectory, boolean createCheckpointSubDirs, JobID jobId, int fileSizeThreshold, int writeBufferSize) throws IOException {
        this(checkpointBaseDirectory.getFileSystem(), checkpointBaseDirectory, defaultSavepointDirectory, createCheckpointSubDirs, jobId, fileSizeThreshold, writeBufferSize);
    }

    public FsCheckpointStorageAccess(FileSystem fs, Path checkpointBaseDirectory, @Nullable Path defaultSavepointDirectory, boolean createCheckpointSubDirs, JobID jobId, int fileSizeThreshold, int writeBufferSize) throws IOException {
        super(jobId, defaultSavepointDirectory);
        Preconditions.checkArgument(fileSizeThreshold >= 0);
        Preconditions.checkArgument(writeBufferSize >= 0);
        this.fileSystem = Preconditions.checkNotNull(fs);
        this.checkpointsDirectory = createCheckpointSubDirs ? FsCheckpointStorageAccess.getCheckpointDirectoryForJob(checkpointBaseDirectory, jobId) : checkpointBaseDirectory;
        this.sharedStateDirectory = new Path(this.checkpointsDirectory, "shared");
        this.taskOwnedStateDirectory = new Path(this.checkpointsDirectory, "taskowned");
        this.fileSizeThreshold = fileSizeThreshold;
        this.writeBufferSize = writeBufferSize;
    }

    public Path getCheckpointsDirectory() {
        return this.checkpointsDirectory;
    }

    public Path getSharedStateDirectory() {
        return this.sharedStateDirectory;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean supportsHighlyAvailableStorage() {
        return true;
    }

    @Override
    public void initializeBaseLocationsForCheckpoint() throws IOException {
        if (!this.fileSystem.mkdirs(this.sharedStateDirectory)) {
            throw new IOException("Failed to create directory for shared state: " + this.sharedStateDirectory);
        }
        if (!this.fileSystem.mkdirs(this.taskOwnedStateDirectory)) {
            throw new IOException("Failed to create directory for task owned state: " + this.taskOwnedStateDirectory);
        }
    }

    @Override
    public CheckpointStorageLocation initializeLocationForCheckpoint(long checkpointId) throws IOException {
        Preconditions.checkArgument(checkpointId >= 0L, "Illegal negative checkpoint id: %s.", checkpointId);
        Path checkpointDir = FsCheckpointStorageAccess.createCheckpointDirectory(this.checkpointsDirectory, checkpointId);
        this.fileSystem.mkdirs(checkpointDir);
        return new FsCheckpointStorageLocation(this.fileSystem, checkpointDir, this.sharedStateDirectory, this.taskOwnedStateDirectory, CheckpointStorageLocationReference.getDefault(), this.fileSizeThreshold, this.writeBufferSize);
    }

    @Override
    public CheckpointStreamFactory resolveCheckpointStorageLocation(long checkpointId, CheckpointStorageLocationReference reference) throws IOException {
        if (reference.isDefaultReference()) {
            Path checkpointDir = FsCheckpointStorageAccess.createCheckpointDirectory(this.checkpointsDirectory, checkpointId);
            return new FsCheckpointStorageLocation(this.fileSystem, checkpointDir, this.sharedStateDirectory, this.taskOwnedStateDirectory, reference, this.fileSizeThreshold, this.writeBufferSize);
        }
        Path path = FsCheckpointStorageAccess.decodePathFromReference(reference);
        return new FsCheckpointStorageLocation(path.getFileSystem(), path, path, path, reference, this.fileSizeThreshold, this.writeBufferSize);
    }

    @Override
    public CheckpointStateOutputStream createTaskOwnedStateStream() {
        return new FsCheckpointStreamFactory.FsCheckpointStateOutputStream(this.taskOwnedStateDirectory, this.fileSystem, this.writeBufferSize, this.fileSizeThreshold);
    }

    @Override
    public CheckpointStateToolset createTaskOwnedCheckpointStateToolset() {
        if (this.fileSystem instanceof PathsCopyingFileSystem) {
            return new FsCheckpointStateToolset(this.taskOwnedStateDirectory, (PathsCopyingFileSystem)((Object)this.fileSystem));
        }
        return new NotDuplicatingCheckpointStateToolset();
    }

    @Override
    protected CheckpointStorageLocation createSavepointLocation(FileSystem fs, Path location) {
        CheckpointStorageLocationReference reference = FsCheckpointStorageAccess.encodePathAsReference(location);
        return new FsCheckpointStorageLocation(fs, location, location, location, reference, this.fileSizeThreshold, this.writeBufferSize);
    }

    @Override
    public FsMergingCheckpointStorageAccess toFileMergingStorage(FileMergingSnapshotManager mergingSnapshotManager, Environment environment) throws IOException {
        return new FsMergingCheckpointStorageAccess(this.checkpointsDirectory, this.getDefaultSavepointDirectory(), environment.getJobID(), this.fileSizeThreshold, this.writeBufferSize, mergingSnapshotManager, environment);
    }
}

