/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.LongPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.LocalSnapshotDirectoryProvider;
import org.apache.flink.runtime.state.OwnedTaskLocalStateStore;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskLocalStateStoreImpl
implements OwnedTaskLocalStateStore {
    private static final Logger LOG = LoggerFactory.getLogger(TaskLocalStateStoreImpl.class);
    @VisibleForTesting
    static final TaskStateSnapshot NULL_DUMMY = new TaskStateSnapshot(0, false);
    public static final String TASK_STATE_SNAPSHOT_FILENAME = "_task_state_snapshot";
    @Nonnull
    protected final JobID jobID;
    @Nonnull
    protected final AllocationID allocationID;
    @Nonnull
    protected final JobVertexID jobVertexID;
    @Nonnegative
    protected final int subtaskIndex;
    @Nonnull
    protected final LocalRecoveryConfig localRecoveryConfig;
    @Nonnull
    protected final Executor discardExecutor;
    @Nonnull
    protected final Object lock = new Object();
    @GuardedBy(value="lock")
    protected boolean disposed;
    @Nonnull
    @GuardedBy(value="lock")
    protected final SortedMap<Long, TaskStateSnapshot> storedTaskStateByCheckpointID;

    public TaskLocalStateStoreImpl(@Nonnull JobID jobID, @Nonnull AllocationID allocationID, @Nonnull JobVertexID jobVertexID, @Nonnegative int subtaskIndex, @Nonnull LocalRecoveryConfig localRecoveryConfig, @Nonnull Executor discardExecutor) {
        this.jobID = jobID;
        this.allocationID = allocationID;
        this.jobVertexID = jobVertexID;
        this.subtaskIndex = subtaskIndex;
        this.discardExecutor = discardExecutor;
        this.localRecoveryConfig = localRecoveryConfig;
        this.storedTaskStateByCheckpointID = new TreeMap<Long, TaskStateSnapshot>();
        this.disposed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeLocalState(@Nonnegative long checkpointId, @Nullable TaskStateSnapshot localState) {
        if (localState == null) {
            localState = NULL_DUMMY;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Stored local state for checkpoint {} in subtask ({} - {} - {}) : {}.", new Object[]{checkpointId, this.jobID, this.jobVertexID, this.subtaskIndex, localState});
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Stored local state for checkpoint {} in subtask ({} - {} - {})", new Object[]{checkpointId, this.jobID, this.jobVertexID, this.subtaskIndex});
        }
        Tuple2<Long, TaskStateSnapshot> toDiscard = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.disposed) {
                toDiscard = Tuple2.of(checkpointId, localState);
            } else {
                TaskStateSnapshot previous = this.storedTaskStateByCheckpointID.put(checkpointId, localState);
                this.persistLocalStateMetadata(checkpointId, localState);
                if (previous != null) {
                    toDiscard = Tuple2.of(checkpointId, previous);
                }
            }
        }
        if (toDiscard != null) {
            this.asyncDiscardLocalStateForCollection(Collections.singletonList(toDiscard));
        }
    }

    private void persistLocalStateMetadata(long checkpointId, TaskStateSnapshot localState) {
        this.createFolderOrFail(this.getCheckpointDirectory(checkpointId));
        File taskStateSnapshotFile = this.getTaskStateSnapshotFile(checkpointId);
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(taskStateSnapshotFile));){
            oos.writeObject(localState);
            LOG.debug("Successfully written local task state snapshot file {} for checkpoint {}.", (Object)taskStateSnapshotFile, (Object)checkpointId);
        }
        catch (IOException e) {
            ExceptionUtils.rethrow(e, "Could not write the local task state snapshot file.");
        }
    }

    @VisibleForTesting
    File getTaskStateSnapshotFile(long checkpointId) {
        return new File(this.getCheckpointDirectory(checkpointId), TASK_STATE_SNAPSHOT_FILENAME);
    }

    protected File getCheckpointDirectory(long checkpointId) {
        return this.getLocalRecoveryDirectoryProvider().subtaskSpecificCheckpointDirectory(checkpointId);
    }

    private void createFolderOrFail(File checkpointDirectory) {
        if (!checkpointDirectory.exists() && !checkpointDirectory.mkdirs()) {
            throw new FlinkRuntimeException(String.format("Could not create the checkpoint directory '%s'", checkpointDirectory));
        }
    }

    protected LocalSnapshotDirectoryProvider getLocalRecoveryDirectoryProvider() {
        return this.localRecoveryConfig.getLocalStateDirectoryProvider().orElseThrow(() -> new IllegalStateException("Local recovery must be enabled."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public TaskStateSnapshot retrieveLocalState(long checkpointID) {
        TaskStateSnapshot snapshot;
        Object object = this.lock;
        synchronized (object) {
            snapshot = this.loadTaskStateSnapshot(checkpointID);
        }
        if (!this.localRecoveryConfig.isLocalRecoveryEnabled()) {
            LOG.debug("Local recovery is disabled for checkpoint {} in subtask ({} - {} - {})", new Object[]{checkpointID, this.jobID, this.jobVertexID, this.subtaskIndex});
            return null;
        }
        if (snapshot != null) {
            LOG.info("Found registered local state for checkpoint {} in subtask ({} - {} - {}) : {}", new Object[]{checkpointID, this.jobID, this.jobVertexID, this.subtaskIndex, snapshot});
        } else {
            LOG.info("Did not find registered local state for checkpoint {} in subtask ({} - {} - {})", new Object[]{checkpointID, this.jobID, this.jobVertexID, this.subtaskIndex});
        }
        return snapshot != NULL_DUMMY ? snapshot : null;
    }

    @Nullable
    @GuardedBy(value="lock")
    private TaskStateSnapshot loadTaskStateSnapshot(long checkpointID) {
        return this.storedTaskStateByCheckpointID.computeIfAbsent(checkpointID, this::tryLoadTaskStateSnapshotFromDisk);
    }

    @Nullable
    @GuardedBy(value="lock")
    private TaskStateSnapshot tryLoadTaskStateSnapshotFromDisk(long checkpointID) {
        File taskStateSnapshotFile = this.getTaskStateSnapshotFile(checkpointID);
        if (taskStateSnapshotFile.exists()) {
            TaskStateSnapshot taskStateSnapshot = null;
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(taskStateSnapshotFile));){
                taskStateSnapshot = (TaskStateSnapshot)ois.readObject();
                LOG.debug("Loaded task state snapshot for checkpoint {} successfully from disk.", (Object)checkpointID);
            }
            catch (IOException | ClassNotFoundException e) {
                LOG.debug("Could not read task state snapshot file {} for checkpoint {}. Deleting the corresponding local state.", (Object)taskStateSnapshotFile, (Object)checkpointID);
                this.discardLocalStateForCheckpoint(checkpointID, Optional.empty());
            }
            return taskStateSnapshot;
        }
        return null;
    }

    @Override
    @Nonnull
    public LocalRecoveryConfig getLocalRecoveryConfig() {
        return this.localRecoveryConfig;
    }

    @Override
    public void confirmCheckpoint(long confirmedCheckpointId) {
        LOG.debug("Received confirmation for checkpoint {} in subtask ({} - {} - {}). Starting to prune history.", new Object[]{confirmedCheckpointId, this.jobID, this.jobVertexID, this.subtaskIndex});
        this.pruneCheckpoints(snapshotCheckpointId -> snapshotCheckpointId < confirmedCheckpointId, true);
    }

    @Override
    public void abortCheckpoint(long abortedCheckpointId) {
        LOG.debug("Received abort information for checkpoint {} in subtask ({} - {} - {}). Starting to prune history.", new Object[]{abortedCheckpointId, this.jobID, this.jobVertexID, this.subtaskIndex});
        this.pruneCheckpoints(snapshotCheckpointId -> snapshotCheckpointId == abortedCheckpointId, false);
    }

    @Override
    public void pruneMatchingCheckpoints(@Nonnull LongPredicate matcher) {
        this.pruneCheckpoints(matcher, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> dispose() {
        Collection statesCopy;
        Object object = this.lock;
        synchronized (object) {
            this.disposed = true;
            statesCopy = this.storedTaskStateByCheckpointID.entrySet().stream().map(entry -> Tuple2.of((Long)entry.getKey(), (TaskStateSnapshot)entry.getValue())).collect(Collectors.toList());
            this.storedTaskStateByCheckpointID.clear();
        }
        return CompletableFuture.runAsync(() -> {
            this.syncDiscardLocalStateForCollection(statesCopy);
            for (int i = 0; i < this.getLocalRecoveryDirectoryProvider().allocationBaseDirsCount(); ++i) {
                File subtaskBaseDirectory = this.getLocalRecoveryDirectoryProvider().selectSubtaskBaseDirectory(i);
                try {
                    this.deleteDirectory(subtaskBaseDirectory);
                    continue;
                }
                catch (IOException e) {
                    LOG.warn("Exception when deleting local recovery subtask base directory {} in subtask ({} - {} - {})", new Object[]{subtaskBaseDirectory, this.jobID, this.jobVertexID, this.subtaskIndex, e});
                }
            }
        }, this.discardExecutor);
    }

    private void asyncDiscardLocalStateForCollection(Collection<Tuple2<Long, TaskStateSnapshot>> toDiscard) {
        if (!toDiscard.isEmpty()) {
            this.discardExecutor.execute(() -> this.syncDiscardLocalStateForCollection(toDiscard));
        }
    }

    private void syncDiscardLocalStateForCollection(Collection<Tuple2<Long, TaskStateSnapshot>> toDiscard) {
        for (Tuple2<Long, TaskStateSnapshot> entry : toDiscard) {
            this.discardLocalStateForCheckpoint((Long)entry.f0, Optional.of((TaskStateSnapshot)entry.f1));
        }
    }

    private void discardLocalStateForCheckpoint(long checkpointID, Optional<TaskStateSnapshot> o) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Discarding local task state snapshot of checkpoint {} for subtask ({} - {} - {}).", new Object[]{checkpointID, this.jobID, this.jobVertexID, this.subtaskIndex});
        } else {
            LOG.debug("Discarding local task state snapshot {} of checkpoint {} for subtask ({} - {} - {}).", new Object[]{o, checkpointID, this.jobID, this.jobVertexID, this.subtaskIndex});
        }
        o.ifPresent(taskStateSnapshot -> {
            try {
                taskStateSnapshot.discardState();
            }
            catch (Exception discardEx) {
                LOG.warn("Exception while discarding local task state snapshot of checkpoint {} in subtask ({} - {} - {}).", new Object[]{checkpointID, this.jobID, this.jobVertexID, this.subtaskIndex, discardEx});
            }
        });
        File checkpointDir = this.getCheckpointDirectory(checkpointID);
        LOG.debug("Deleting local state directory {} of checkpoint {} for subtask ({} - {} - {}).", new Object[]{checkpointDir, checkpointID, this.jobID, this.jobVertexID, this.subtaskIndex});
        try {
            this.deleteDirectory(checkpointDir);
        }
        catch (IOException ex) {
            LOG.warn("Exception while deleting local state directory of checkpoint {} in subtask ({} - {} - {}).", new Object[]{checkpointID, this.jobID, this.jobVertexID, this.subtaskIndex, ex});
        }
    }

    protected void deleteDirectory(File directory) throws IOException {
        Path path = new Path(directory.toURI());
        FileSystem fileSystem = path.getFileSystem();
        if (fileSystem.exists(path)) {
            fileSystem.delete(path, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pruneCheckpoints(LongPredicate pruningChecker, boolean breakOnceCheckerFalse) {
        ArrayList<Tuple2<Long, TaskStateSnapshot>> toRemove = new ArrayList<Tuple2<Long, TaskStateSnapshot>>();
        Object object = this.lock;
        synchronized (object) {
            Iterator<Map.Entry<Long, TaskStateSnapshot>> entryIterator = this.storedTaskStateByCheckpointID.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry<Long, TaskStateSnapshot> snapshotEntry = entryIterator.next();
                long entryCheckpointId = snapshotEntry.getKey();
                if (pruningChecker.test(entryCheckpointId)) {
                    toRemove.add(Tuple2.of(entryCheckpointId, snapshotEntry.getValue()));
                    entryIterator.remove();
                    continue;
                }
                if (!breakOnceCheckerFalse) continue;
                break;
            }
        }
        this.asyncDiscardLocalStateForCollection(toRemove);
    }

    public String toString() {
        return "TaskLocalStateStore{jobID=" + this.jobID + ", jobVertexID=" + this.jobVertexID + ", allocationID=" + this.allocationID.toHexString() + ", subtaskIndex=" + this.subtaskIndex + ", localRecoveryConfig=" + this.localRecoveryConfig + ", storedCheckpointIDs=" + this.storedTaskStateByCheckpointID.keySet() + "}";
    }
}

