/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.checkpoints;

import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.FailedCheckpointStats;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.checkpoint.SavepointType;
import org.apache.flink.runtime.checkpoint.SnapshotType;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.checkpoints.TaskCheckpointStatistics;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDKeyDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobVertexIDKeySerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="className")
@JsonSubTypes(value={@JsonSubTypes.Type(value=CompletedCheckpointStatistics.class, name="completed"), @JsonSubTypes.Type(value=FailedCheckpointStatistics.class, name="failed"), @JsonSubTypes.Type(value=PendingCheckpointStatistics.class, name="in_progress")})
@Schema(discriminatorProperty="className", discriminatorMapping={@DiscriminatorMapping(value="completed", schema=CompletedCheckpointStatistics.class), @DiscriminatorMapping(value="failed", schema=FailedCheckpointStatistics.class), @DiscriminatorMapping(value="in_progress", schema=PendingCheckpointStatistics.class)})
public class CheckpointStatistics
implements ResponseBody {
    public static final String FIELD_NAME_ID = "id";
    public static final String FIELD_NAME_STATUS = "status";
    public static final String FIELD_NAME_IS_SAVEPOINT = "is_savepoint";
    public static final String FIELD_NAME_SAVEPOINT_FORMAT = "savepointFormat";
    public static final String FIELD_NAME_TRIGGER_TIMESTAMP = "trigger_timestamp";
    public static final String FIELD_NAME_LATEST_ACK_TIMESTAMP = "latest_ack_timestamp";
    public static final String FIELD_NAME_CHECKPOINTED_SIZE = "checkpointed_size";
    public static final String FIELD_NAME_STATE_SIZE = "state_size";
    public static final String FIELD_NAME_DURATION = "end_to_end_duration";
    public static final String FIELD_NAME_ALIGNMENT_BUFFERED = "alignment_buffered";
    public static final String FIELD_NAME_PROCESSED_DATA = "processed_data";
    public static final String FIELD_NAME_PERSISTED_DATA = "persisted_data";
    public static final String FIELD_NAME_NUM_SUBTASKS = "num_subtasks";
    public static final String FIELD_NAME_NUM_ACK_SUBTASKS = "num_acknowledged_subtasks";
    public static final String FIELD_NAME_TASKS = "tasks";
    public static final String FIELD_NAME_CHECKPOINT_TYPE = "checkpoint_type";
    @JsonProperty(value="id")
    private final long id;
    @JsonProperty(value="status")
    private final CheckpointStatsStatus status;
    @JsonProperty(value="is_savepoint")
    private final boolean savepoint;
    @JsonProperty(value="savepointFormat")
    @Nullable
    private final String savepointFormat;
    @JsonProperty(value="trigger_timestamp")
    private final long triggerTimestamp;
    @JsonProperty(value="latest_ack_timestamp")
    private final long latestAckTimestamp;
    @JsonProperty(value="checkpointed_size")
    private final long checkpointedSize;
    @JsonProperty(value="state_size")
    private final long stateSize;
    @JsonProperty(value="end_to_end_duration")
    private final long duration;
    @JsonProperty(value="alignment_buffered")
    private final long alignmentBuffered;
    @JsonProperty(value="processed_data")
    private final long processedData;
    @JsonProperty(value="persisted_data")
    private final long persistedData;
    @JsonProperty(value="num_subtasks")
    private final int numSubtasks;
    @JsonProperty(value="num_acknowledged_subtasks")
    private final int numAckSubtasks;
    @JsonProperty(value="checkpoint_type")
    private final RestAPICheckpointType checkpointType;
    @JsonProperty(value="tasks")
    @JsonSerialize(keyUsing=JobVertexIDKeySerializer.class)
    private final Map<JobVertexID, TaskCheckpointStatistics> checkpointStatisticsPerTask;

    @JsonCreator
    private CheckpointStatistics(@JsonProperty(value="id") long id, @JsonProperty(value="status") CheckpointStatsStatus status, @JsonProperty(value="is_savepoint") boolean savepoint, @JsonProperty(value="savepointFormat") String savepointFormat, @JsonProperty(value="trigger_timestamp") long triggerTimestamp, @JsonProperty(value="latest_ack_timestamp") long latestAckTimestamp, @JsonProperty(value="checkpointed_size") long checkpointedSize, @JsonProperty(value="state_size") long stateSize, @JsonProperty(value="end_to_end_duration") long duration, @JsonProperty(value="alignment_buffered") long alignmentBuffered, @JsonProperty(value="processed_data") long processedData, @JsonProperty(value="persisted_data") long persistedData, @JsonProperty(value="num_subtasks") int numSubtasks, @JsonProperty(value="num_acknowledged_subtasks") int numAckSubtasks, @JsonProperty(value="checkpoint_type") RestAPICheckpointType checkpointType, @JsonDeserialize(keyUsing=JobVertexIDKeyDeserializer.class) @JsonProperty(value="tasks") Map<JobVertexID, TaskCheckpointStatistics> checkpointStatisticsPerTask) {
        this.id = id;
        this.status = Preconditions.checkNotNull(status);
        this.savepoint = savepoint;
        this.savepointFormat = savepointFormat;
        this.triggerTimestamp = triggerTimestamp;
        this.latestAckTimestamp = latestAckTimestamp;
        this.checkpointedSize = checkpointedSize;
        this.stateSize = stateSize;
        this.duration = duration;
        this.alignmentBuffered = alignmentBuffered;
        this.processedData = processedData;
        this.persistedData = persistedData;
        this.numSubtasks = numSubtasks;
        this.numAckSubtasks = numAckSubtasks;
        this.checkpointType = Preconditions.checkNotNull(checkpointType);
        this.checkpointStatisticsPerTask = Preconditions.checkNotNull(checkpointStatisticsPerTask);
    }

    public long getId() {
        return this.id;
    }

    public CheckpointStatsStatus getStatus() {
        return this.status;
    }

    public boolean isSavepoint() {
        return this.savepoint;
    }

    public long getTriggerTimestamp() {
        return this.triggerTimestamp;
    }

    public long getLatestAckTimestamp() {
        return this.latestAckTimestamp;
    }

    public long getCheckpointedSize() {
        return this.checkpointedSize;
    }

    public long getStateSize() {
        return this.stateSize;
    }

    public long getDuration() {
        return this.duration;
    }

    public int getNumSubtasks() {
        return this.numSubtasks;
    }

    public int getNumAckSubtasks() {
        return this.numAckSubtasks;
    }

    public RestAPICheckpointType getCheckpointType() {
        return this.checkpointType;
    }

    @Nullable
    public Map<JobVertexID, TaskCheckpointStatistics> getCheckpointStatisticsPerTask() {
        return this.checkpointStatisticsPerTask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointStatistics that = (CheckpointStatistics)o;
        return this.id == that.id && this.savepoint == that.savepoint && Objects.equals(this.savepointFormat, that.savepointFormat) && this.triggerTimestamp == that.triggerTimestamp && this.latestAckTimestamp == that.latestAckTimestamp && this.stateSize == that.stateSize && this.duration == that.duration && this.alignmentBuffered == that.alignmentBuffered && this.processedData == that.processedData && this.persistedData == that.persistedData && this.numSubtasks == that.numSubtasks && this.numAckSubtasks == that.numAckSubtasks && this.status == that.status && Objects.equals((Object)this.checkpointType, (Object)that.checkpointType) && Objects.equals(this.checkpointStatisticsPerTask, that.checkpointStatisticsPerTask);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.status, this.savepoint, this.savepointFormat, this.triggerTimestamp, this.latestAckTimestamp, this.stateSize, this.duration, this.alignmentBuffered, this.processedData, this.persistedData, this.numSubtasks, this.numAckSubtasks, this.checkpointType, this.checkpointStatisticsPerTask});
    }

    public static CheckpointStatistics generateCheckpointStatistics(AbstractCheckpointStats checkpointStats, boolean includeTaskCheckpointStatistics) {
        Map<JobVertexID, TaskCheckpointStatistics> checkpointStatisticsPerTask;
        Preconditions.checkNotNull(checkpointStats);
        if (includeTaskCheckpointStatistics) {
            Collection<TaskStateStats> taskStateStats = checkpointStats.getAllTaskStateStats();
            checkpointStatisticsPerTask = CollectionUtil.newHashMapWithExpectedSize(taskStateStats.size());
            for (TaskStateStats taskStateStat : taskStateStats) {
                checkpointStatisticsPerTask.put(taskStateStat.getJobVertexId(), new TaskCheckpointStatistics(checkpointStats.getCheckpointId(), checkpointStats.getStatus(), taskStateStat.getLatestAckTimestamp(), taskStateStat.getCheckpointedSize(), taskStateStat.getStateSize(), taskStateStat.getEndToEndDuration(checkpointStats.getTriggerTimestamp()), 0L, taskStateStat.getProcessedDataStats(), taskStateStat.getPersistedDataStats(), taskStateStat.getNumberOfSubtasks(), taskStateStat.getNumberOfAcknowledgedSubtasks()));
            }
        } else {
            checkpointStatisticsPerTask = Collections.emptyMap();
        }
        String savepointFormat = null;
        SnapshotType snapshotType = checkpointStats.getProperties().getCheckpointType();
        if (snapshotType instanceof SavepointType) {
            savepointFormat = ((SavepointType)snapshotType).getFormatType().name();
        }
        if (checkpointStats instanceof CompletedCheckpointStats) {
            CompletedCheckpointStats completedCheckpointStats = (CompletedCheckpointStats)checkpointStats;
            return new CompletedCheckpointStatistics(completedCheckpointStats.getCheckpointId(), completedCheckpointStats.getStatus(), snapshotType.isSavepoint(), savepointFormat, completedCheckpointStats.getTriggerTimestamp(), completedCheckpointStats.getLatestAckTimestamp(), completedCheckpointStats.getCheckpointedSize(), completedCheckpointStats.getStateSize(), completedCheckpointStats.getEndToEndDuration(), 0L, completedCheckpointStats.getProcessedData(), completedCheckpointStats.getPersistedData(), completedCheckpointStats.getNumberOfSubtasks(), completedCheckpointStats.getNumberOfAcknowledgedSubtasks(), RestAPICheckpointType.valueOf(completedCheckpointStats.getProperties().getCheckpointType(), completedCheckpointStats.isUnalignedCheckpoint()), checkpointStatisticsPerTask, completedCheckpointStats.getExternalPath(), completedCheckpointStats.isDiscarded());
        }
        if (checkpointStats instanceof FailedCheckpointStats) {
            FailedCheckpointStats failedCheckpointStats = (FailedCheckpointStats)checkpointStats;
            return new FailedCheckpointStatistics(failedCheckpointStats.getCheckpointId(), failedCheckpointStats.getStatus(), failedCheckpointStats.getProperties().isSavepoint(), savepointFormat, failedCheckpointStats.getTriggerTimestamp(), failedCheckpointStats.getLatestAckTimestamp(), failedCheckpointStats.getCheckpointedSize(), failedCheckpointStats.getStateSize(), failedCheckpointStats.getEndToEndDuration(), 0L, failedCheckpointStats.getProcessedData(), failedCheckpointStats.getPersistedData(), failedCheckpointStats.getNumberOfSubtasks(), failedCheckpointStats.getNumberOfAcknowledgedSubtasks(), RestAPICheckpointType.valueOf(failedCheckpointStats.getProperties().getCheckpointType(), failedCheckpointStats.isUnalignedCheckpoint()), checkpointStatisticsPerTask, failedCheckpointStats.getFailureTimestamp(), failedCheckpointStats.getFailureMessage());
        }
        if (checkpointStats instanceof PendingCheckpointStats) {
            PendingCheckpointStats pendingCheckpointStats = (PendingCheckpointStats)checkpointStats;
            return new PendingCheckpointStatistics(pendingCheckpointStats.getCheckpointId(), pendingCheckpointStats.getStatus(), pendingCheckpointStats.getProperties().isSavepoint(), savepointFormat, pendingCheckpointStats.getTriggerTimestamp(), pendingCheckpointStats.getLatestAckTimestamp(), pendingCheckpointStats.getCheckpointedSize(), pendingCheckpointStats.getStateSize(), pendingCheckpointStats.getEndToEndDuration(), 0L, pendingCheckpointStats.getProcessedData(), pendingCheckpointStats.getPersistedData(), pendingCheckpointStats.getNumberOfSubtasks(), pendingCheckpointStats.getNumberOfAcknowledgedSubtasks(), RestAPICheckpointType.valueOf(pendingCheckpointStats.getProperties().getCheckpointType(), pendingCheckpointStats.isUnalignedCheckpoint()), checkpointStatisticsPerTask);
        }
        throw new IllegalArgumentException("Given checkpoint stats object of type " + checkpointStats.getClass().getName() + " cannot be converted.");
    }

    public static final class PendingCheckpointStatistics
    extends CheckpointStatistics {
        @JsonCreator
        public PendingCheckpointStatistics(@JsonProperty(value="id") long id, @JsonProperty(value="status") CheckpointStatsStatus status, @JsonProperty(value="is_savepoint") boolean savepoint, @JsonProperty(value="savepointFormat") String savepointFormat, @JsonProperty(value="trigger_timestamp") long triggerTimestamp, @JsonProperty(value="latest_ack_timestamp") long latestAckTimestamp, @JsonProperty(value="checkpointed_size") long checkpointedSize, @JsonProperty(value="state_size") long stateSize, @JsonProperty(value="end_to_end_duration") long duration, @JsonProperty(value="alignment_buffered") long alignmentBuffered, @JsonProperty(value="processed_data") long processedData, @JsonProperty(value="persisted_data") long persistedData, @JsonProperty(value="num_subtasks") int numSubtasks, @JsonProperty(value="num_acknowledged_subtasks") int numAckSubtasks, @JsonProperty(value="checkpoint_type") RestAPICheckpointType checkpointType, @JsonDeserialize(keyUsing=JobVertexIDKeyDeserializer.class) @JsonProperty(value="tasks") Map<JobVertexID, TaskCheckpointStatistics> checkpointingStatisticsPerTask) {
            super(id, status, savepoint, savepointFormat, triggerTimestamp, latestAckTimestamp, checkpointedSize, stateSize, duration, alignmentBuffered, processedData, persistedData, numSubtasks, numAckSubtasks, checkpointType, checkpointingStatisticsPerTask);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode());
        }
    }

    public static final class FailedCheckpointStatistics
    extends CheckpointStatistics {
        public static final String FIELD_NAME_FAILURE_TIMESTAMP = "failure_timestamp";
        public static final String FIELD_NAME_FAILURE_MESSAGE = "failure_message";
        @JsonProperty(value="failure_timestamp")
        private final long failureTimestamp;
        @JsonProperty(value="failure_message")
        @Nullable
        private final String failureMessage;

        @JsonCreator
        public FailedCheckpointStatistics(@JsonProperty(value="id") long id, @JsonProperty(value="status") CheckpointStatsStatus status, @JsonProperty(value="is_savepoint") boolean savepoint, @JsonProperty(value="savepointFormat") String savepointFormat, @JsonProperty(value="trigger_timestamp") long triggerTimestamp, @JsonProperty(value="latest_ack_timestamp") long latestAckTimestamp, @JsonProperty(value="checkpointed_size") long checkpointedSize, @JsonProperty(value="state_size") long stateSize, @JsonProperty(value="end_to_end_duration") long duration, @JsonProperty(value="alignment_buffered") long alignmentBuffered, @JsonProperty(value="processed_data") long processedData, @JsonProperty(value="persisted_data") long persistedData, @JsonProperty(value="num_subtasks") int numSubtasks, @JsonProperty(value="num_acknowledged_subtasks") int numAckSubtasks, @JsonProperty(value="checkpoint_type") RestAPICheckpointType checkpointType, @JsonDeserialize(keyUsing=JobVertexIDKeyDeserializer.class) @JsonProperty(value="tasks") Map<JobVertexID, TaskCheckpointStatistics> checkpointingStatisticsPerTask, @JsonProperty(value="failure_timestamp") long failureTimestamp, @JsonProperty(value="failure_message") @Nullable String failureMessage) {
            super(id, status, savepoint, savepointFormat, triggerTimestamp, latestAckTimestamp, checkpointedSize, stateSize, duration, alignmentBuffered, processedData, persistedData, numSubtasks, numAckSubtasks, checkpointType, checkpointingStatisticsPerTask);
            this.failureTimestamp = failureTimestamp;
            this.failureMessage = failureMessage;
        }

        public long getFailureTimestamp() {
            return this.failureTimestamp;
        }

        @Nullable
        public String getFailureMessage() {
            return this.failureMessage;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FailedCheckpointStatistics that = (FailedCheckpointStatistics)o;
            return this.failureTimestamp == that.failureTimestamp && Objects.equals(this.failureMessage, that.failureMessage);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.failureTimestamp, this.failureMessage);
        }
    }

    public static final class CompletedCheckpointStatistics
    extends CheckpointStatistics {
        public static final String FIELD_NAME_EXTERNAL_PATH = "external_path";
        public static final String FIELD_NAME_DISCARDED = "discarded";
        @JsonProperty(value="external_path")
        @Nullable
        private final String externalPath;
        @JsonProperty(value="discarded")
        private final boolean discarded;

        @JsonCreator
        public CompletedCheckpointStatistics(@JsonProperty(value="id") long id, @JsonProperty(value="status") CheckpointStatsStatus status, @JsonProperty(value="is_savepoint") boolean savepoint, @JsonProperty(value="savepointFormat") String savepointFormat, @JsonProperty(value="trigger_timestamp") long triggerTimestamp, @JsonProperty(value="latest_ack_timestamp") long latestAckTimestamp, @JsonProperty(value="checkpointed_size") long checkpointedSize, @JsonProperty(value="state_size") long stateSize, @JsonProperty(value="end_to_end_duration") long duration, @JsonProperty(value="alignment_buffered") long alignmentBuffered, @JsonProperty(value="processed_data") long processedData, @JsonProperty(value="persisted_data") long persistedData, @JsonProperty(value="num_subtasks") int numSubtasks, @JsonProperty(value="num_acknowledged_subtasks") int numAckSubtasks, @JsonProperty(value="checkpoint_type") RestAPICheckpointType checkpointType, @JsonDeserialize(keyUsing=JobVertexIDKeyDeserializer.class) @JsonProperty(value="tasks") Map<JobVertexID, TaskCheckpointStatistics> checkpointingStatisticsPerTask, @JsonProperty(value="external_path") @Nullable String externalPath, @JsonProperty(value="discarded") boolean discarded) {
            super(id, status, savepoint, savepointFormat, triggerTimestamp, latestAckTimestamp, checkpointedSize, stateSize, duration, alignmentBuffered, processedData, persistedData, numSubtasks, numAckSubtasks, checkpointType, checkpointingStatisticsPerTask);
            this.externalPath = externalPath;
            this.discarded = discarded;
        }

        @Nullable
        public String getExternalPath() {
            return this.externalPath;
        }

        public boolean isDiscarded() {
            return this.discarded;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CompletedCheckpointStatistics that = (CompletedCheckpointStatistics)o;
            return this.discarded == that.discarded && Objects.equals(this.externalPath, that.externalPath);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.externalPath, this.discarded);
        }
    }

    static enum RestAPICheckpointType {
        CHECKPOINT,
        UNALIGNED_CHECKPOINT,
        SAVEPOINT,
        SYNC_SAVEPOINT;


        public static RestAPICheckpointType valueOf(SnapshotType checkpointType, boolean isUnalignedCheckpoint) {
            if (checkpointType.isSavepoint()) {
                Preconditions.checkArgument(!isUnalignedCheckpoint, "Currently the savepoint doesn't support unaligned checkpoint.");
                SavepointType savepointType = (SavepointType)checkpointType;
                return savepointType.isSynchronous() ? SYNC_SAVEPOINT : SAVEPOINT;
            }
            if (isUnalignedCheckpoint) {
                return UNALIGNED_CHECKPOINT;
            }
            return CHECKPOINT;
        }
    }
}

