/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.Metric;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricCollectionResponseBody;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricsFilterParameter;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public abstract class AbstractMetricsHandler<M extends MessageParameters>
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, MetricCollectionResponseBody, M> {
    private final MetricFetcher metricFetcher;

    public AbstractMetricsHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> headers, MessageHeaders<EmptyRequestBody, MetricCollectionResponseBody, M> messageHeaders, MetricFetcher metricFetcher) {
        super(leaderRetriever, timeout, headers, messageHeaders);
        this.metricFetcher = Objects.requireNonNull(metricFetcher, "metricFetcher must not be null");
    }

    @Override
    protected final CompletableFuture<MetricCollectionResponseBody> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        this.metricFetcher.update();
        MetricStore.ComponentMetricStore componentMetricStore = this.getComponentMetricStore(request, this.metricFetcher.getMetricStore());
        if (componentMetricStore == null || componentMetricStore.metrics == null) {
            return CompletableFuture.completedFuture(new MetricCollectionResponseBody(Collections.emptyList()));
        }
        HashSet<String> requestedMetrics = new HashSet<String>(request.getQueryParameter(MetricsFilterParameter.class));
        if (requestedMetrics.isEmpty()) {
            return CompletableFuture.completedFuture(new MetricCollectionResponseBody(AbstractMetricsHandler.getAvailableMetrics(componentMetricStore)));
        }
        List<Metric> metrics = AbstractMetricsHandler.getRequestedMetrics(componentMetricStore, requestedMetrics);
        return CompletableFuture.completedFuture(new MetricCollectionResponseBody(metrics));
    }

    @Nullable
    protected abstract MetricStore.ComponentMetricStore getComponentMetricStore(HandlerRequest<EmptyRequestBody> var1, MetricStore var2);

    private static List<Metric> getAvailableMetrics(MetricStore.ComponentMetricStore componentMetricStore) {
        return componentMetricStore.metrics.keySet().stream().map(Metric::new).collect(Collectors.toList());
    }

    private static List<Metric> getRequestedMetrics(MetricStore.ComponentMetricStore componentMetricStore, Set<String> requestedMetrics) throws RestHandlerException {
        ArrayList<Metric> metrics = new ArrayList<Metric>(requestedMetrics.size());
        for (String requestedMetric : requestedMetrics) {
            String value = componentMetricStore.getMetric(requestedMetric, null);
            if (value == null) continue;
            metrics.add(new Metric(requestedMetric, value));
        }
        return metrics;
    }
}

