/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.checkpoints;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.checkpoints.AbstractCheckpointStatsHandler;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointStatsCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointIdPathParameter;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.guava32.com.google.common.cache.Cache;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.Preconditions;

public abstract class AbstractCheckpointHandler<R extends ResponseBody, M extends CheckpointMessageParameters>
extends AbstractCheckpointStatsHandler<R, M> {
    private final CheckpointStatsCache checkpointStatsCache;

    protected AbstractCheckpointHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, R, M> messageHeaders, Executor executor, Cache<JobID, CompletableFuture<CheckpointStatsSnapshot>> checkpointStatsSnapshotCache, CheckpointStatsCache checkpointStatsCache) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, checkpointStatsSnapshotCache, executor);
        this.checkpointStatsCache = Preconditions.checkNotNull(checkpointStatsCache);
    }

    @Override
    protected R handleCheckpointStatsRequest(HandlerRequest<EmptyRequestBody> request, CheckpointStatsSnapshot checkpointStatsSnapshot) throws RestHandlerException {
        JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
        long checkpointId = (Long)request.getPathParameter(CheckpointIdPathParameter.class);
        if (checkpointStatsSnapshot != null) {
            AbstractCheckpointStats checkpointStats = checkpointStatsSnapshot.getHistory().getCheckpointById(checkpointId);
            if (checkpointStats != null) {
                this.checkpointStatsCache.tryAdd(checkpointStats);
            } else {
                checkpointStats = this.checkpointStatsCache.tryGet(checkpointId);
            }
            if (checkpointStats != null) {
                return this.handleCheckpointRequest(request, checkpointStats);
            }
            throw new RestHandlerException("Could not find checkpointing statistics for checkpoint " + checkpointId + ".", HttpResponseStatus.NOT_FOUND);
        }
        throw new RestHandlerException("Checkpointing was not enabled for job " + jobId + ".", HttpResponseStatus.NOT_FOUND);
    }

    protected abstract R handleCheckpointRequest(HandlerRequest<EmptyRequestBody> var1, AbstractCheckpointStats var2) throws RestHandlerException;
}

