/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobResourceRequirements;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyResponseBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.job.JobResourceRequirementsBody;
import org.apache.flink.runtime.rest.messages.job.JobResourcesRequirementsUpdateHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;

public class JobResourceRequirementsUpdateHandler
extends AbstractRestHandler<RestfulGateway, JobResourceRequirementsBody, EmptyResponseBody, JobMessageParameters> {
    public JobResourceRequirementsUpdateHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> responseHeaders) {
        super(leaderRetriever, timeout, responseHeaders, JobResourcesRequirementsUpdateHeaders.INSTANCE);
    }

    @Override
    protected CompletableFuture<EmptyResponseBody> handleRequest(@Nonnull HandlerRequest<JobResourceRequirementsBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
        Optional<JobResourceRequirements> maybeJobResourceRequirements = request.getRequestBody().asJobResourceRequirements();
        if (maybeJobResourceRequirements.isPresent()) {
            return gateway.updateJobResourceRequirements(jobId, maybeJobResourceRequirements.get()).thenApply(ignored -> EmptyResponseBody.getInstance());
        }
        throw new RestHandlerException("Request body does not specify resource requirements.", HttpResponseStatus.BAD_REQUEST);
    }
}

