/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.time.Duration;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpecFactory;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerConfiguration;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.Preconditions;

public class ResourceManagerRuntimeServicesConfiguration {
    private final Duration jobTimeout;
    private final SlotManagerConfiguration slotManagerConfiguration;

    public ResourceManagerRuntimeServicesConfiguration(Duration jobTimeout, SlotManagerConfiguration slotManagerConfiguration) {
        this.jobTimeout = Preconditions.checkNotNull(jobTimeout);
        this.slotManagerConfiguration = Preconditions.checkNotNull(slotManagerConfiguration);
    }

    public Duration getJobTimeout() {
        return this.jobTimeout;
    }

    public SlotManagerConfiguration getSlotManagerConfiguration() {
        return this.slotManagerConfiguration;
    }

    public static ResourceManagerRuntimeServicesConfiguration fromConfiguration(Configuration configuration, WorkerResourceSpecFactory defaultWorkerResourceSpecFactory) throws ConfigurationException {
        Duration jobTimeout;
        try {
            jobTimeout = configuration.get(ResourceManagerOptions.JOB_TIMEOUT);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Could not parse the resource manager's job timeout value " + ResourceManagerOptions.JOB_TIMEOUT + ".", e);
        }
        WorkerResourceSpec defaultWorkerResourceSpec = defaultWorkerResourceSpecFactory.createDefaultWorkerResourceSpec(configuration);
        SlotManagerConfiguration slotManagerConfiguration = SlotManagerConfiguration.fromConfiguration(configuration, defaultWorkerResourceSpec);
        return new ResourceManagerRuntimeServicesConfiguration(jobTimeout, slotManagerConfiguration);
    }
}

