/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.time.Duration;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RpcOptions;
import org.apache.flink.runtime.registration.RetryingRegistrationConfiguration;
import org.apache.flink.util.Preconditions;

public class JobMasterConfiguration {
    private final Duration rpcTimeout;
    private final Duration slotRequestTimeout;
    private final String tmpDirectory;
    private final RetryingRegistrationConfiguration retryingRegistrationConfiguration;
    private final Configuration configuration;

    public JobMasterConfiguration(Duration rpcTimeout, Duration slotRequestTimeout, String tmpDirectory, RetryingRegistrationConfiguration retryingRegistrationConfiguration, Configuration configuration) {
        this.rpcTimeout = Preconditions.checkNotNull(rpcTimeout);
        this.slotRequestTimeout = Preconditions.checkNotNull(slotRequestTimeout);
        this.tmpDirectory = Preconditions.checkNotNull(tmpDirectory);
        this.retryingRegistrationConfiguration = retryingRegistrationConfiguration;
        this.configuration = Preconditions.checkNotNull(configuration);
    }

    public Duration getRpcTimeout() {
        return this.rpcTimeout;
    }

    public Duration getSlotRequestTimeout() {
        return this.slotRequestTimeout;
    }

    public String getTmpDirectory() {
        return this.tmpDirectory;
    }

    public RetryingRegistrationConfiguration getRetryingRegistrationConfiguration() {
        return this.retryingRegistrationConfiguration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public static JobMasterConfiguration fromConfiguration(Configuration configuration) {
        Duration rpcTimeout = configuration.get(RpcOptions.ASK_TIMEOUT_DURATION);
        Duration slotRequestTimeout = configuration.get(JobManagerOptions.SLOT_REQUEST_TIMEOUT);
        String tmpDirectory = ConfigurationUtils.parseTempDirectories(configuration)[0];
        RetryingRegistrationConfiguration retryingRegistrationConfiguration = RetryingRegistrationConfiguration.fromConfiguration(configuration);
        return new JobMasterConfiguration(rpcTimeout, slotRequestTimeout, tmpDirectory, retryingRegistrationConfiguration, configuration);
    }
}

