/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.util.Preconditions;

public class RestoredCheckpointStats
implements Serializable {
    private static final long serialVersionUID = 2305815319666360821L;
    private final long checkpointId;
    private final CheckpointProperties props;
    private final long restoreTimestamp;
    @Nullable
    private final String externalPath;
    private final long stateSize;

    RestoredCheckpointStats(long checkpointId, CheckpointProperties props, long restoreTimestamp, @Nullable String externalPath, long stateSize) {
        this.checkpointId = checkpointId;
        this.props = Preconditions.checkNotNull(props, "Checkpoint Properties");
        this.restoreTimestamp = restoreTimestamp;
        this.externalPath = externalPath;
        this.stateSize = stateSize;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public CheckpointProperties getProperties() {
        return this.props;
    }

    public long getRestoreTimestamp() {
        return this.restoreTimestamp;
    }

    @Nullable
    public String getExternalPath() {
        return this.externalPath;
    }

    public long getStateSize() {
        return this.stateSize;
    }

    public int hashCode() {
        return Objects.hash(this.checkpointId, this.props, this.restoreTimestamp, this.externalPath, this.stateSize);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoredCheckpointStats that = (RestoredCheckpointStats)o;
        return this.checkpointId == that.checkpointId && this.props == that.props && this.restoreTimestamp == that.restoreTimestamp && this.externalPath == that.externalPath && this.stateSize == that.stateSize;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{checkpointId=" + this.checkpointId + "props=" + this.props + "restoreTimestamp=" + this.restoreTimestamp + "externalPath=" + this.externalPath + "stateSize=" + this.stateSize + "}";
    }
}

