/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.scheduler.adaptive.allocator.JobInformation;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotSharingSlotAllocator;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

class AllocatorUtil {
    private AllocatorUtil() {
    }

    static Map<SlotSharingGroupId, SlotSharingSlotAllocator.SlotSharingGroupMetaInfo> getSlotSharingGroupMetaInfos(JobInformation jobInformation) {
        return SlotSharingSlotAllocator.SlotSharingGroupMetaInfo.from(jobInformation.getVertices());
    }

    static int getMinimumRequiredSlots(Map<SlotSharingGroupId, SlotSharingSlotAllocator.SlotSharingGroupMetaInfo> slotSharingGroupMetaInfos) {
        return slotSharingGroupMetaInfos.values().stream().map(SlotSharingSlotAllocator.SlotSharingGroupMetaInfo::getMaxLowerBound).reduce(0, Integer::sum);
    }

    static void checkMinimumRequiredSlots(JobInformation jobInformation, Collection<? extends SlotInfo> freeSlots) {
        int minimumRequiredSlots = AllocatorUtil.getMinimumRequiredSlots(AllocatorUtil.getSlotSharingGroupMetaInfos(jobInformation));
        Preconditions.checkState(freeSlots.size() >= minimumRequiredSlots, "Not enough slots to allocate all the execution slot sharing groups (have: %s, need: %s)", freeSlots.size(), minimumRequiredSlots);
    }

    static List<SlotSharingSlotAllocator.ExecutionSlotSharingGroup> createExecutionSlotSharingGroups(VertexParallelism vertexParallelism, SlotSharingGroup slotSharingGroup) {
        HashMap sharedSlotToVertexAssignment = new HashMap();
        slotSharingGroup.getJobVertexIds().forEach(jobVertexId -> {
            int parallelism = vertexParallelism.getParallelism((JobVertexID)jobVertexId);
            for (int subtaskIdx = 0; subtaskIdx < parallelism; ++subtaskIdx) {
                sharedSlotToVertexAssignment.computeIfAbsent(subtaskIdx, ignored -> new HashSet()).add(new ExecutionVertexID((JobVertexID)jobVertexId, subtaskIdx));
            }
        });
        return sharedSlotToVertexAssignment.values().stream().map(SlotSharingSlotAllocator.ExecutionSlotSharingGroup::new).collect(Collectors.toList());
    }
}

