/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierMasterAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleDescriptor;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleHandler;
import org.apache.flink.runtime.shuffle.NettyShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.util.Preconditions;

public class TieredStorageMasterClient {
    private final List<TierMasterAgent> tiers;

    public TieredStorageMasterClient(List<TierMasterAgent> tiers) {
        this.tiers = tiers;
    }

    public void registerJob(JobID jobID, TierShuffleHandler shuffleHandler) {
        this.tiers.forEach(tierMasterAgent -> tierMasterAgent.registerJob(jobID, shuffleHandler));
    }

    public void unregisterJob(JobID jobID) {
        this.tiers.forEach(tierMasterAgent -> tierMasterAgent.unregisterJob(jobID));
    }

    public List<TierShuffleDescriptor> addPartitionAndGetShuffleDescriptor(JobID jobID, ResultPartitionID resultPartitionID) {
        return this.tiers.stream().map(tierMasterAgent -> tierMasterAgent.addPartitionAndGetShuffleDescriptor(jobID, resultPartitionID)).collect(Collectors.toList());
    }

    public void releasePartition(ShuffleDescriptor shuffleDescriptor) {
        Preconditions.checkState(shuffleDescriptor instanceof NettyShuffleDescriptor);
        List<TierShuffleDescriptor> tierShuffleDescriptors = ((NettyShuffleDescriptor)shuffleDescriptor).getTierShuffleDescriptors();
        if (tierShuffleDescriptors != null && !tierShuffleDescriptors.isEmpty()) {
            Preconditions.checkState(tierShuffleDescriptors.size() == this.tiers.size());
            for (int i = 0; i < tierShuffleDescriptors.size(); ++i) {
                this.tiers.get(i).releasePartition(tierShuffleDescriptors.get(i));
            }
        }
    }

    public void close() {
        this.tiers.forEach(TierMasterAgent::close);
    }
}

