/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.java.tuple.Tuple2;

public final class StronglyConnectedComponentsComputeUtils {
    private StronglyConnectedComponentsComputeUtils() {
    }

    static Set<Set<Integer>> computeStronglyConnectedComponents(int numVertex, List<List<Integer>> outEdges) {
        HashSet<Set<Integer>> stronglyConnectedComponents = new HashSet<Set<Integer>>();
        ArrayDeque<Integer> visitingStack = new ArrayDeque<Integer>(numVertex);
        boolean[] onVisitingStack = new boolean[numVertex];
        int[] vertexIndices = new int[numVertex];
        Arrays.fill(vertexIndices, -1);
        AtomicInteger indexCounter = new AtomicInteger(0);
        int[] vertexLowLinks = new int[numVertex];
        for (int vertex = 0; vertex < numVertex; ++vertex) {
            if (StronglyConnectedComponentsComputeUtils.isVisited(vertex, vertexIndices)) continue;
            StronglyConnectedComponentsComputeUtils.dfs(vertex, outEdges, vertexIndices, vertexLowLinks, visitingStack, onVisitingStack, indexCounter, stronglyConnectedComponents);
        }
        return stronglyConnectedComponents;
    }

    private static boolean isVisited(int vertex, int[] vertexIndices) {
        return vertexIndices[vertex] != -1;
    }

    private static void dfs(int rootVertex, List<List<Integer>> outEdges, int[] vertexIndices, int[] vertexLowLinks, Deque<Integer> visitingStack, boolean[] onVisitingStack, AtomicInteger indexCounter, Set<Set<Integer>> stronglyConnectedComponents) {
        ArrayDeque<Tuple2<Integer, Integer>> dfsLoopStack = new ArrayDeque<Tuple2<Integer, Integer>>();
        dfsLoopStack.add(new Tuple2<Integer, Integer>(rootVertex, 0));
        while (!dfsLoopStack.isEmpty()) {
            Tuple2 tuple = (Tuple2)dfsLoopStack.pollLast();
            int currentVertex = (Integer)tuple.f0;
            int vertexOutEdgeIndex = (Integer)tuple.f1;
            if (vertexOutEdgeIndex == 0) {
                StronglyConnectedComponentsComputeUtils.startTraversingVertex(currentVertex, vertexIndices, vertexLowLinks, visitingStack, onVisitingStack, indexCounter);
            } else if (vertexOutEdgeIndex > 0) {
                StronglyConnectedComponentsComputeUtils.finishTraversingOutEdge(currentVertex, vertexOutEdgeIndex - 1, outEdges, vertexLowLinks);
            }
            if (StronglyConnectedComponentsComputeUtils.traverseOutEdges(currentVertex, vertexOutEdgeIndex, outEdges, vertexIndices, vertexLowLinks, onVisitingStack, dfsLoopStack) || vertexLowLinks[currentVertex] != vertexIndices[currentVertex]) continue;
            stronglyConnectedComponents.add(StronglyConnectedComponentsComputeUtils.createConnectedComponent(currentVertex, visitingStack, onVisitingStack));
        }
    }

    private static void startTraversingVertex(int currentVertex, int[] vertexIndices, int[] vertexLowLinks, Deque<Integer> visitingStack, boolean[] onVisitingStack, AtomicInteger indexCounter) {
        vertexIndices[currentVertex] = indexCounter.get();
        vertexLowLinks[currentVertex] = indexCounter.getAndIncrement();
        visitingStack.add(currentVertex);
        onVisitingStack[currentVertex] = true;
    }

    private static void finishTraversingOutEdge(int currentVertex, int vertexOutEdgeIndex, List<List<Integer>> outEdges, int[] vertexLowLinks) {
        int successorVertex = outEdges.get(currentVertex).get(vertexOutEdgeIndex);
        vertexLowLinks[currentVertex] = Math.min(vertexLowLinks[currentVertex], vertexLowLinks[successorVertex]);
    }

    private static boolean traverseOutEdges(int currentVertex, int vertexOutEdgeIndex, List<List<Integer>> outEdges, int[] vertexIndices, int[] vertexLowLinks, boolean[] onVisitingStack, Deque<Tuple2<Integer, Integer>> dfsLoopStack) {
        for (int i = vertexOutEdgeIndex; i < outEdges.get(currentVertex).size(); ++i) {
            int successorVertex = outEdges.get(currentVertex).get(i);
            if (!StronglyConnectedComponentsComputeUtils.isVisited(successorVertex, vertexIndices)) {
                dfsLoopStack.add(new Tuple2<Integer, Integer>(currentVertex, i + 1));
                dfsLoopStack.add(new Tuple2<Integer, Integer>(successorVertex, 0));
                return true;
            }
            if (!onVisitingStack[successorVertex]) continue;
            vertexLowLinks[currentVertex] = Math.min(vertexLowLinks[currentVertex], vertexIndices[successorVertex]);
        }
        return false;
    }

    private static Set<Integer> createConnectedComponent(int currentVertex, Deque<Integer> visitingStack, boolean[] onVisitingStack) {
        HashSet<Integer> scc = new HashSet<Integer>();
        while (onVisitingStack[currentVertex]) {
            int v = visitingStack.pollLast();
            onVisitingStack[v] = false;
            scc.add(v);
        }
        return scc;
    }
}

