/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.FactoryUtil;

@Internal
public class ExecutableOperationUtils {
    public static DynamicTableSink createDynamicTableSink(@Nullable Catalog catalog, Supplier<Optional<DynamicTableSinkFactory>> sinkFactorySupplier, ObjectIdentifier objectIdentifier, ResolvedCatalogTable catalogTable, Map<String, String> enrichmentOptions, ReadableConfig configuration, ClassLoader classLoader, boolean isTemporary) {
        DynamicTableSinkFactory dynamicTableSinkFactory = null;
        if (catalog != null && catalog.getFactory().isPresent() && catalog.getFactory().get() instanceof DynamicTableSinkFactory) {
            dynamicTableSinkFactory = (DynamicTableSinkFactory)catalog.getFactory().get();
        }
        if (dynamicTableSinkFactory == null) {
            dynamicTableSinkFactory = sinkFactorySupplier.get().orElse(null);
        }
        return FactoryUtil.createDynamicTableSink(dynamicTableSinkFactory, objectIdentifier, catalogTable, enrichmentOptions, configuration, classLoader, isTemporary);
    }
}

