/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.binary;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.data.binary.BinaryFormat;
import org.apache.flink.table.data.binary.BinarySection;
import org.apache.flink.util.WrappingRuntimeException;

@Internal
public abstract class LazyBinaryFormat<T>
implements BinaryFormat {
    T javaObject;
    BinarySection binarySection;

    public LazyBinaryFormat() {
        this(null, null);
    }

    public LazyBinaryFormat(MemorySegment[] segments, int offset, int sizeInBytes, T javaObject) {
        this(javaObject, new BinarySection(segments, offset, sizeInBytes));
    }

    public LazyBinaryFormat(MemorySegment[] segments, int offset, int sizeInBytes) {
        this(null, new BinarySection(segments, offset, sizeInBytes));
    }

    public LazyBinaryFormat(T javaObject) {
        this(javaObject, null);
    }

    public LazyBinaryFormat(T javaObject, BinarySection binarySection) {
        this.javaObject = javaObject;
        this.binarySection = binarySection;
    }

    public T getJavaObject() {
        return this.javaObject;
    }

    public BinarySection getBinarySection() {
        return this.binarySection;
    }

    public void setJavaObject(T javaObject) {
        this.javaObject = javaObject;
    }

    @Override
    public MemorySegment[] getSegments() {
        if (this.binarySection == null) {
            throw new IllegalStateException("Lazy Binary Format was not materialized");
        }
        return this.binarySection.segments;
    }

    @Override
    public int getOffset() {
        if (this.binarySection == null) {
            throw new IllegalStateException("Lazy Binary Format was not materialized");
        }
        return this.binarySection.offset;
    }

    @Override
    public int getSizeInBytes() {
        if (this.binarySection == null) {
            throw new IllegalStateException("Lazy Binary Format was not materialized");
        }
        return this.binarySection.sizeInBytes;
    }

    public final void ensureMaterialized(TypeSerializer<T> serializer) {
        if (this.binarySection == null) {
            try {
                this.binarySection = this.materialize(serializer);
            }
            catch (IOException e) {
                throw new WrappingRuntimeException(e);
            }
        }
    }

    protected abstract BinarySection materialize(TypeSerializer<T> var1) throws IOException;
}

