/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.io.ByteArrayOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.cli.CliStrings;
import org.apache.flink.table.client.cli.CliUtils;
import org.apache.flink.table.client.cli.Printer;
import org.apache.flink.table.client.cli.SqlCompleter;
import org.apache.flink.table.client.cli.TerminalUtils;
import org.apache.flink.table.client.cli.parser.SqlClientSyntaxHighlighter;
import org.apache.flink.table.client.cli.parser.SqlCommandParserImpl;
import org.apache.flink.table.client.cli.parser.SqlMultiLineParser;
import org.apache.flink.table.client.config.SqlClientOptions;
import org.apache.flink.table.client.gateway.Executor;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.MaskingCallback;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CliClient.class);
    public static final Supplier<Terminal> DEFAULT_TERMINAL_FACTORY = TerminalUtils::createDefaultTerminal;
    private static final String NEWLINE_PROMPT = new AttributedStringBuilder().style(AttributedStyle.DEFAULT.foreground(2)).append("Flink SQL").style(AttributedStyle.DEFAULT).append("> ").toAnsi();
    private static final String SHOW_LINE_NUMBERS_PATTERN = "%N%M> ";
    private final Executor executor;
    private final Path historyFilePath;
    @Nullable
    private final MaskingCallback inputTransformer;
    private final Supplier<Terminal> terminalFactory;
    private Terminal terminal;
    private boolean isRunning;

    @VisibleForTesting
    public CliClient(Supplier<Terminal> terminalFactory, Executor executor, Path historyFilePath, @Nullable MaskingCallback inputTransformer) {
        this.terminalFactory = terminalFactory;
        this.executor = executor;
        this.inputTransformer = inputTransformer;
        this.historyFilePath = historyFilePath;
    }

    public CliClient(Supplier<Terminal> terminalFactory, Executor executor, Path historyFilePath) {
        this(terminalFactory, executor, historyFilePath, null);
    }

    @Override
    public void close() {
        if (this.terminal != null) {
            this.closeTerminal();
        }
    }

    public void executeInInteractiveMode() {
        this.executeInInteractiveMode(null);
    }

    @VisibleForTesting
    void executeInInteractiveMode(LineReader lineReader) {
        try {
            this.terminal = this.terminalFactory.get();
            this.executeInteractive(lineReader);
        }
        finally {
            this.closeTerminal();
        }
    }

    public void executeInNonInteractiveMode(String content) {
        try {
            this.terminal = this.terminalFactory.get();
            this.executeFile(content, this.terminal.output(), ExecutionMode.NON_INTERACTIVE_EXECUTION);
        }
        finally {
            this.closeTerminal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeInitialization(String content) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(256);
            this.terminal = TerminalUtils.createDumbTerminal(outputStream);
            boolean success = this.executeFile(content, outputStream, ExecutionMode.INITIALIZATION);
            LOG.info(((Object)outputStream).toString());
            boolean bl = success;
            return bl;
        }
        finally {
            this.closeTerminal();
        }
    }

    private void executeInteractive(LineReader inputLineReader) {
        this.terminal.writer().println();
        this.terminal.writer().flush();
        this.terminal.writer().append(CliStrings.MESSAGE_WELCOME);
        LineReader lineReader = inputLineReader == null ? this.createLineReader(this.terminal, ExecutionMode.INTERACTIVE_EXECUTION) : inputLineReader;
        this.getAndExecuteStatements(lineReader, false);
    }

    private boolean getAndExecuteStatements(LineReader lineReader, boolean exitOnFailure) {
        this.isRunning = true;
        SqlMultiLineParser parser = (SqlMultiLineParser)lineReader.getParser();
        while (this.isRunning) {
            this.terminal.writer().append("\n");
            this.terminal.flush();
            try {
                String line = lineReader.readLine(NEWLINE_PROMPT, null, this.inputTransformer, null);
                lineReader.setVariable("secondary-prompt-pattern", this.executor.getSessionConfig().get(SqlClientOptions.DISPLAY_SHOW_LINE_NUMBERS) != false ? SHOW_LINE_NUMBERS_PATTERN : "%M> ");
                if (line.trim().isEmpty()) continue;
                Printer printer = parser.getPrinter();
                boolean success = this.print(printer);
                if (!exitOnFailure || success) continue;
                return false;
            }
            catch (UserInterruptException printer) {
            }
            catch (IOError | EndOfFileException e) {
                break;
            }
            catch (SqlExecutionException e) {
                this.printExecutionException(e);
                if (!exitOnFailure) continue;
                return false;
            }
            catch (Throwable t) {
                throw new SqlClientException("Could not read from command line.", t);
            }
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private boolean executeFile(String content, OutputStream outputStream, ExecutionMode mode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean print(Printer printer) {
        try {
            Thread thread = Thread.currentThread();
            Terminal.SignalHandler previousHandler = this.terminal.handle(Terminal.Signal.INT, signal -> thread.interrupt());
            try {
                printer.print(this.terminal);
                if (printer.isQuitCommand()) {
                    this.isRunning = false;
                }
            }
            finally {
                this.terminal.handle(Terminal.Signal.INT, previousHandler);
            }
        }
        catch (SqlExecutionException e) {
            this.printExecutionException(e);
            return false;
        }
        return true;
    }

    private void printExecutionException(Throwable t) {
        String errorMessage = "Could not execute SQL statement.";
        LOG.warn("Could not execute SQL statement.", t);
        boolean isVerbose = this.executor.getSessionConfig().get(SqlClientOptions.VERBOSE);
        this.terminal.writer().println(CliStrings.messageError("Could not execute SQL statement.", t, isVerbose).toAnsi());
        this.terminal.flush();
    }

    private void closeTerminal() {
        try {
            this.terminal.close();
            this.terminal = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private LineReader createLineReader(Terminal terminal, ExecutionMode mode) {
        SqlMultiLineParser parser = new SqlMultiLineParser(new SqlCommandParserImpl(), this.executor, mode);
        LineReaderBuilder builder = LineReaderBuilder.builder().terminal(terminal).appName("Flink SQL CLI Client").parser(parser);
        if (mode == ExecutionMode.INTERACTIVE_EXECUTION) {
            builder.completer(new SqlCompleter(this.executor));
            builder.highlighter(new SqlClientSyntaxHighlighter(this.executor));
        }
        LineReader lineReader = builder.build();
        lineReader.option(LineReader.Option.DISABLE_EVENT_EXPANSION, true);
        lineReader.setVariable("errors", 1);
        lineReader.option(LineReader.Option.CASE_INSENSITIVE, true);
        if (Files.exists(this.historyFilePath, new LinkOption[0]) || CliUtils.createFile(this.historyFilePath)) {
            String msg = "Command history file path: " + this.historyFilePath;
            terminal.writer().println(msg);
            LOG.info(msg);
            lineReader.setVariable("history-file", this.historyFilePath);
        } else {
            String msg = "Unable to create history file: " + this.historyFilePath;
            terminal.writer().println(msg);
            LOG.warn(msg);
        }
        return lineReader;
    }

    public static enum ExecutionMode {
        INTERACTIVE_EXECUTION,
        NON_INTERACTIVE_EXECUTION,
        INITIALIZATION;

    }
}

