/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.json.SerializedValueDeserializer;
import org.apache.flink.runtime.rest.messages.json.SerializedValueSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public class JobAccumulatorsInfo
implements ResponseBody {
    public static final String FIELD_NAME_JOB_ACCUMULATORS = "job-accumulators";
    public static final String FIELD_NAME_USER_TASK_ACCUMULATORS = "user-task-accumulators";
    public static final String FIELD_NAME_SERIALIZED_USER_TASK_ACCUMULATORS = "serialized-user-task-accumulators";
    @JsonProperty(value="job-accumulators")
    private List<JobAccumulator> jobAccumulators;
    @JsonProperty(value="user-task-accumulators")
    private List<UserTaskAccumulator> userAccumulators;
    @JsonProperty(value="serialized-user-task-accumulators")
    @JsonSerialize(contentUsing=SerializedValueSerializer.class)
    private Map<String, SerializedValue<OptionalFailure<Object>>> serializedUserAccumulators;

    @JsonCreator
    public JobAccumulatorsInfo(@JsonProperty(value="job-accumulators") List<JobAccumulator> jobAccumulators, @JsonProperty(value="user-task-accumulators") List<UserTaskAccumulator> userAccumulators, @JsonDeserialize(contentUsing=SerializedValueDeserializer.class) @JsonProperty(value="serialized-user-task-accumulators") Map<String, SerializedValue<OptionalFailure<Object>>> serializedUserAccumulators) {
        this.jobAccumulators = Preconditions.checkNotNull(jobAccumulators);
        this.userAccumulators = Preconditions.checkNotNull(userAccumulators);
        this.serializedUserAccumulators = Preconditions.checkNotNull(serializedUserAccumulators);
    }

    @JsonIgnore
    public List<JobAccumulator> getJobAccumulators() {
        return this.jobAccumulators;
    }

    @JsonIgnore
    public List<UserTaskAccumulator> getUserAccumulators() {
        return this.userAccumulators;
    }

    @JsonIgnore
    public Map<String, SerializedValue<OptionalFailure<Object>>> getSerializedUserAccumulators() {
        return this.serializedUserAccumulators;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobAccumulatorsInfo that = (JobAccumulatorsInfo)o;
        return Objects.equals(this.userAccumulators, that.userAccumulators);
    }

    public int hashCode() {
        return Objects.hash(this.userAccumulators);
    }

    public static final class UserTaskAccumulator {
        public static final String FIELD_NAME_ACC_NAME = "name";
        public static final String FIELD_NAME_ACC_TYPE = "type";
        public static final String FIELD_NAME_ACC_VALUE = "value";
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="value")
        private String value;

        @JsonCreator
        public UserTaskAccumulator(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="value") String value) {
            this.name = Preconditions.checkNotNull(name);
            this.type = Preconditions.checkNotNull(type);
            this.value = Preconditions.checkNotNull(value);
        }

        @JsonIgnore
        public String getName() {
            return this.name;
        }

        @JsonIgnore
        public String getType() {
            return this.type;
        }

        @JsonIgnore
        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserTaskAccumulator that = (UserTaskAccumulator)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type, this.value);
        }
    }

    public static final class JobAccumulator {
    }
}

