/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.checkpoint;

import java.io.Serializable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;

public abstract class AbstractCheckpointMessage
implements Serializable {
    private static final long serialVersionUID = 186780414819428178L;
    private final JobID job;
    private final ExecutionAttemptID taskExecutionId;
    private final long checkpointId;

    protected AbstractCheckpointMessage(JobID job, ExecutionAttemptID taskExecutionId, long checkpointId) {
        if (job == null || taskExecutionId == null) {
            throw new NullPointerException();
        }
        this.job = job;
        this.taskExecutionId = taskExecutionId;
        this.checkpointId = checkpointId;
    }

    public JobID getJob() {
        return this.job;
    }

    public ExecutionAttemptID getTaskExecutionId() {
        return this.taskExecutionId;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public int hashCode() {
        return this.job.hashCode() + this.taskExecutionId.hashCode() + (int)(this.checkpointId ^ this.checkpointId >>> 32);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AbstractCheckpointMessage) {
            AbstractCheckpointMessage that = (AbstractCheckpointMessage)o;
            return this.job.equals(that.job) && this.taskExecutionId.equals(that.taskExecutionId) && this.checkpointId == that.checkpointId;
        }
        return false;
    }

    public String toString() {
        return "(" + this.checkpointId + ':' + this.job + '/' + this.taskExecutionId + ')';
    }
}

