/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.util.FlinkException;
import org.slf4j.Logger;

public abstract class AbstractCustomCommandLine
implements CustomCommandLine {
    protected final Option zookeeperNamespaceOption = new Option("z", "zookeeperNamespace", true, "Namespace to create the Zookeeper sub-paths for high availability mode");

    @Override
    public void addRunOptions(Options baseOptions) {
    }

    @Override
    public void addGeneralOptions(Options baseOptions) {
        baseOptions.addOption(this.zookeeperNamespaceOption);
    }

    @Override
    public Configuration toConfiguration(CommandLine commandLine) throws FlinkException {
        Configuration resultingConfiguration = new Configuration();
        resultingConfiguration.set((ConfigOption)DeploymentOptions.TARGET, "remote");
        if (commandLine.hasOption(this.zookeeperNamespaceOption.getOpt())) {
            String zkNamespace = commandLine.getOptionValue(this.zookeeperNamespaceOption.getOpt());
            resultingConfiguration.set((ConfigOption)HighAvailabilityOptions.HA_CLUSTER_ID, zkNamespace);
        }
        return resultingConfiguration;
    }

    protected void printUsage() {
        System.out.println("Usage:");
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(200);
        formatter.setLeftPadding(5);
        formatter.setSyntaxPrefix("   Optional");
        Options options = new Options();
        this.addGeneralOptions(options);
        this.addRunOptions(options);
        formatter.printHelp(" ", options);
    }

    public static int handleCliArgsException(CliArgsException e, Logger logger) {
        logger.error("Could not parse the command line arguments.", (Throwable)e);
        System.out.println(e.getMessage());
        System.out.println();
        System.out.println("Use the help option (-h or --help) to get help on the command.");
        return 1;
    }

    public static int handleError(Throwable t, Logger logger) {
        logger.error("Error while running the Flink session.", t);
        System.err.println();
        System.err.println("------------------------------------------------------------");
        System.err.println(" The program finished with the following exception:");
        System.err.println();
        t.printStackTrace();
        return 1;
    }
}

