/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.UseOperation;

@Internal
public class UseModulesOperation
implements UseOperation {
    private final List<String> moduleNames;

    public UseModulesOperation(List<String> moduleNames) {
        this.moduleNames = Collections.unmodifiableList(moduleNames);
    }

    public List<String> getModuleNames() {
        return this.moduleNames;
    }

    @Override
    public String asSummaryString() {
        return String.format("USE MODULES: %s", this.moduleNames);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        try {
            ctx.getModuleManager().useModules(this.moduleNames.toArray(new String[0]));
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw new ValidationException(String.format("Could not execute %s. %s", this.asSummaryString(), e.getMessage()), e);
        }
    }
}

