/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStorageAccess;
import org.apache.flink.runtime.state.filesystem.FsMergingCheckpointStorageLocation;

public class FsMergingCheckpointStorageAccess
extends FsCheckpointStorageAccess
implements Closeable {
    private final FileMergingSnapshotManager fileMergingSnapshotManager;
    private final FileMergingSnapshotManager.SubtaskKey subtaskKey;

    public FsMergingCheckpointStorageAccess(Path checkpointBaseDirectory, @Nullable Path defaultSavepointDirectory, JobID jobId, int fileSizeThreshold, int writeBufferSize, FileMergingSnapshotManager fileMergingSnapshotManager, Environment environment) throws IOException {
        super(FileSystem.getUnguardedFileSystem(checkpointBaseDirectory.toUri()), checkpointBaseDirectory, defaultSavepointDirectory, false, jobId, fileSizeThreshold, writeBufferSize);
        this.fileMergingSnapshotManager = fileMergingSnapshotManager;
        this.subtaskKey = FileMergingSnapshotManager.SubtaskKey.of(environment);
    }

    @Override
    public void initializeBaseLocationsForCheckpoint() throws IOException {
        super.initializeBaseLocationsForCheckpoint();
        this.fileMergingSnapshotManager.initFileSystem(this.fileSystem, this.checkpointsDirectory, this.sharedStateDirectory, this.taskOwnedStateDirectory, this.writeBufferSize);
        this.fileMergingSnapshotManager.registerSubtaskForSharedStates(this.subtaskKey);
    }

    @Override
    public CheckpointStreamFactory resolveCheckpointStorageLocation(long checkpointId, CheckpointStorageLocationReference reference) throws IOException {
        if (reference.isDefaultReference()) {
            Path checkpointDir = FsMergingCheckpointStorageAccess.createCheckpointDirectory(this.checkpointsDirectory, checkpointId);
            return new FsMergingCheckpointStorageLocation(this.subtaskKey, this.fileSystem, checkpointDir, this.sharedStateDirectory, this.taskOwnedStateDirectory, reference, this.fileSizeThreshold, this.writeBufferSize, this.fileMergingSnapshotManager, checkpointId);
        }
        Path path = FsMergingCheckpointStorageAccess.decodePathFromReference(reference);
        return new FsMergingCheckpointStorageLocation(this.subtaskKey, path.getFileSystem(), path, path, path, reference, this.fileSizeThreshold, this.writeBufferSize, this.fileMergingSnapshotManager, checkpointId);
    }

    @Override
    public void close() {
        this.fileMergingSnapshotManager.unregisterSubtask(this.subtaskKey);
    }
}

