/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.query;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.runtime.execution.SuppressRestartsException;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.query.KvStateLocation;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.util.Preconditions;

public class KvStateLocationRegistry {
    private final JobID jobId;
    private final Map<JobVertexID, ExecutionJobVertex> jobVertices;
    private final Map<String, KvStateLocation> lookupTable = new HashMap<String, KvStateLocation>();

    public KvStateLocationRegistry(JobID jobId, Map<JobVertexID, ExecutionJobVertex> jobVertices) {
        this.jobId = Preconditions.checkNotNull(jobId, "JobID");
        this.jobVertices = Preconditions.checkNotNull(jobVertices, "Job vertices");
    }

    public KvStateLocation getKvStateLocation(String registrationName) {
        return this.lookupTable.get(registrationName);
    }

    public void notifyKvStateRegistered(JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName, KvStateID kvStateId, InetSocketAddress kvStateServerAddress) {
        KvStateLocation location = this.lookupTable.get(registrationName);
        if (location == null) {
            ExecutionJobVertex vertex = this.jobVertices.get(jobVertexId);
            if (vertex != null) {
                int parallelism = vertex.getMaxParallelism();
                location = new KvStateLocation(this.jobId, jobVertexId, parallelism, registrationName);
                this.lookupTable.put(registrationName, location);
            } else {
                throw new IllegalArgumentException("Unknown JobVertexID " + jobVertexId);
            }
        }
        if (!location.getJobVertexId().equals(jobVertexId)) {
            IllegalStateException duplicate = new IllegalStateException("Registration name clash. KvState with name '" + registrationName + "' has already been registered by another operator (" + location.getJobVertexId() + ").");
            ExecutionJobVertex vertex = this.jobVertices.get(jobVertexId);
            if (vertex != null) {
                vertex.fail(new SuppressRestartsException(duplicate));
            }
            throw duplicate;
        }
        location.registerKvState(keyGroupRange, kvStateId, kvStateServerAddress);
    }

    public void notifyKvStateUnregistered(JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName) {
        KvStateLocation location = this.lookupTable.get(registrationName);
        if (location != null) {
            if (!location.getJobVertexId().equals(jobVertexId)) {
                throw new IllegalArgumentException("Another operator (" + location.getJobVertexId() + ") registered the KvState under '" + registrationName + "'.");
            }
            location.unregisterKvState(keyGroupRange);
            if (location.getNumRegisteredKeyGroups() == 0) {
                this.lookupTable.remove(registrationName);
            }
        } else {
            throw new IllegalArgumentException("Unknown registration name '" + registrationName + "'. Probably registration/unregistration race.");
        }
    }
}

